"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .sortorder import SortOrder
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetMediaClipsRequestTypedDict(TypedDict):
    source_media_id: str
    r"""The unique identifier of the source media."""
    offset: NotRequired[int]
    r"""Offset determines the starting point for data retrieval within a paginated list."""
    limit: NotRequired[int]
    r"""The number of media clips to retrieve per request."""
    order_by: NotRequired[SortOrder]
    r"""The values in the list can be arranged in two ways DESC (Descending) or ASC (Ascending)."""


class GetMediaClipsRequest(BaseModel):
    source_media_id: Annotated[
        str,
        pydantic.Field(alias="sourceMediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The unique identifier of the source media."""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Offset determines the starting point for data retrieval within a paginated list."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""The number of media clips to retrieve per request."""

    order_by: Annotated[
        Optional[SortOrder],
        pydantic.Field(alias="orderBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "desc"
    r"""The values in the list can be arranged in two ways DESC (Descending) or ASC (Ascending)."""
