"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .media import Media, MediaTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetMediaRequestTypedDict(TypedDict):
    media_id: str
    r"""The Media Id is assigned a universal unique identifier, which can contain a maximum of 255 characters."""


class GetMediaRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The Media Id is assigned a universal unique identifier, which can contain a maximum of 255 characters."""


class GetMediaResponseTypedDict(TypedDict):
    r"""Get a video media by id"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[MediaTypedDict]


class GetMediaResponse(BaseModel):
    r"""Get a video media by id"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[Media] = None
