"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .accesspolicy import AccessPolicy
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetPlaybackIDRequestTypedDict(TypedDict):
    media_id: str
    playback_id: str


class GetPlaybackIDRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    playback_id: Annotated[
        str,
        pydantic.Field(alias="playbackId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]


class GetPlaybackIDDataTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The unique identifier for the playback ID."""
    access_policy: NotRequired[AccessPolicy]
    r"""Access policy for media content"""


class GetPlaybackIDData(BaseModel):
    id: Optional[str] = None
    r"""The unique identifier for the playback ID."""

    access_policy: Annotated[
        Optional[AccessPolicy], pydantic.Field(alias="accessPolicy")
    ] = None
    r"""Access policy for media content"""


class GetPlaybackIDResponseTypedDict(TypedDict):
    r"""Successfully retrieved playback ID details"""

    success: NotRequired[bool]
    r"""Indicates if the request was successful or not."""
    data: NotRequired[GetPlaybackIDDataTypedDict]


class GetPlaybackIDResponse(BaseModel):
    r"""Successfully retrieved playback ID details"""

    success: Optional[bool] = None
    r"""Indicates if the request was successful or not."""

    data: Optional[GetPlaybackIDData] = None
