"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .metricstimeseriesdatadetails import (
    MetricsTimeseriesDataDetails,
    MetricsTimeseriesDataDetailsTypedDict,
)
from .metricstimeseriesmetadatadetails import (
    MetricsTimeseriesMetaDataDetails,
    MetricsTimeseriesMetaDataDetailsTypedDict,
)
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


GetTimeseriesDataMetricID = Literal[
    "views",
    "unique_viewers",
    "playing_time",
    "quality_of_experience_score",
    "playback_score",
    "playback_failure_percentage",
    "exit_before_video_start",
    "video_startup_failure_percentage",
    "startup_score",
    "video_startup_time",
    "player_startup_time",
    "page_load_time",
    "total_startup_time",
    "live_stream_latency",
    "average_bitrate",
    "buffer_count",
    "render_quality_score",
    "avg_upscaling",
    "avg_downscaling",
    "max_upscaling",
    "max_downscaling",
    "jump_latency",
    "stability_score",
    "buffer_ratio",
    "buffer_frequency",
    "buffer_fill",
]
r"""Pass metric Id

"""


GroupBy = Literal[
    "minute",
    "ten_minutes",
    "hour",
    "day",
]
r"""Pass this value to group the metrics list by.

"""


GetTimeseriesDataSortOrder = Literal[
    "asc",
    "desc",
]
r"""The order direction to sort the metrics list by.

"""


GetTimeseriesDataTimespan = Literal[
    "60:minutes",
    "6:hours",
    "24:hours",
    "3:days",
    "7:days",
    "30:days",
]
r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

"""


class GetTimeseriesDataRequestTypedDict(TypedDict):
    metric_id: GetTimeseriesDataMetricID
    r"""Pass metric Id

    """
    timespan: GetTimeseriesDataTimespan
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """
    group_by: NotRequired[GroupBy]
    r"""Pass this value to group the metrics list by.

    """
    sort_order: NotRequired[GetTimeseriesDataSortOrder]
    r"""The order direction to sort the metrics list by.

    """
    measurement: NotRequired[str]
    r"""The measurement for the given metrics.
    Possible Values : [95th, median, avg, count or sum]

    """
    filterby: NotRequired[str]
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """


class GetTimeseriesDataRequest(BaseModel):
    metric_id: Annotated[
        GetTimeseriesDataMetricID,
        pydantic.Field(alias="metricId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Pass metric Id

    """

    timespan: Annotated[
        GetTimeseriesDataTimespan,
        pydantic.Field(alias="timespan[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """

    group_by: Annotated[
        Optional[GroupBy],
        pydantic.Field(alias="groupBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "minute"
    r"""Pass this value to group the metrics list by.

    """

    sort_order: Annotated[
        Optional[GetTimeseriesDataSortOrder],
        pydantic.Field(alias="sortOrder"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "asc"
    r"""The order direction to sort the metrics list by.

    """

    measurement: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "avg"
    r"""The measurement for the given metrics.
    Possible Values : [95th, median, avg, count or sum]

    """

    filterby: Annotated[
        Optional[str],
        pydantic.Field(alias="filterby[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """


class GetTimeseriesDataResponseTypedDict(TypedDict):
    r"""Get filter/ dimension value details by dimension name."""

    success: NotRequired[bool]
    r"""It demonstrates whether the request is successful or not."""
    meta_data: NotRequired[MetricsTimeseriesMetaDataDetailsTypedDict]
    r"""Retrieves breakdown values for a specified metric and timespan"""
    data: NotRequired[List[MetricsTimeseriesDataDetailsTypedDict]]
    r"""Displays the result of the request."""
    timespan: NotRequired[List[int]]
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """


class GetTimeseriesDataResponse(BaseModel):
    r"""Get filter/ dimension value details by dimension name."""

    success: Optional[bool] = None
    r"""It demonstrates whether the request is successful or not."""

    meta_data: Annotated[
        Optional[MetricsTimeseriesMetaDataDetails], pydantic.Field(alias="metaData")
    ] = None
    r"""Retrieves breakdown values for a specified metric and timespan"""

    data: Optional[List[MetricsTimeseriesDataDetails]] = None
    r"""Displays the result of the request."""

    timespan: Optional[List[int]] = None
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """
