"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .playbackidresponse import PlaybackIDResponse, PlaybackIDResponseTypedDict
from .srtplaybackresponse import SrtPlaybackResponse, SrtPlaybackResponseTypedDict
from datetime import datetime
from ..types import BaseModel
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetCreateLiveStreamResponseDTOTypedDict(TypedDict):
    r"""Displays the result of the request."""

    stream_id: NotRequired[str]
    r"""Upon creating a new live stream, FastPix assigns a unique identifier to the stream."""
    stream_key: NotRequired[str]
    r"""A unique stream key is generated for streaming, allowing the user to start streaming on any third-party platform using this key."""
    srt_secret: NotRequired[str]
    r"""A secret used for securing the SRT stream. This ensures that only authorized users can access the stream."""
    trial: NotRequired[bool]
    r"""FastPix allows for a to trial the live stream for free. The duration of trial streams is five minutes. After five minutes of activity, the trial stream is turned off, and the recorded asset is removed after a day."""
    status: NotRequired[str]
    r"""The current live stream status can be one of four values:Idle, Preparing, Active or Disabled.The Idle status signifies that there isn't a broadcast in progress.The preparing status indicates that the stream is getting prepared. while, the Active status indicates that a broadcast is currently in progress. The Disabled status means that no more RTMPS streams can be published."""
    max_resolution: NotRequired[str]
    r"""Max resolution can be used to control the maximum resolution your media is encoded, stored, and streamed at."""
    max_duration: NotRequired[int]
    r"""The maximum duration in seconds that a live stream can have before it ends the stream."""
    created_at: NotRequired[datetime]
    r"""It is the moment when the stream was created Time the media was generated, defined as a localDateTime (UTC Time)."""
    reconnect_window: NotRequired[int]
    r"""In case the software streaming the live, gets disrupted for any reason and gets disconnected from FastPix, the reconnect window specifies the time span FastPix will wait before ending the stream. Before starting the stream, you can set the reconnect window time which is up to 1800 seconds."""
    enable_recording: NotRequired[bool]
    r"""When set to true, the livestream will be recorded and stored for later viewing purposes. If set to false, the livestream will not be recorded."""
    media_policy: NotRequired[str]
    r"""Determines whether the recorded stream should be publicly accessible or private in Live to VOD (Video on Demand)."""
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""
    enable_dvr_mode: NotRequired[bool]
    r"""Enables DVR (Digital Video Recorder) functionality for the live stream. When set to true, viewers can pause, rewind, and resume playback during the live broadcast. This allows time-shifted viewing of the stream while it is still ongoing."""
    playback_ids: NotRequired[List[PlaybackIDResponseTypedDict]]
    r"""A collection of Playback ID objects utilized for crafting HLS playback urls."""
    media_ids: NotRequired[List[str]]
    r"""A set of media IDs created after the livestream ends. (live to VOD)"""
    srt_playback_response: NotRequired[SrtPlaybackResponseTypedDict]
    r"""This object contains the livestream playback response details for SRT Protocol"""


class GetCreateLiveStreamResponseDTO(BaseModel):
    r"""Displays the result of the request."""

    stream_id: Annotated[Optional[str], pydantic.Field(alias="streamId")] = None
    r"""Upon creating a new live stream, FastPix assigns a unique identifier to the stream."""

    stream_key: Annotated[Optional[str], pydantic.Field(alias="streamKey")] = None
    r"""A unique stream key is generated for streaming, allowing the user to start streaming on any third-party platform using this key."""

    srt_secret: Annotated[Optional[str], pydantic.Field(alias="srtSecret")] = None
    r"""A secret used for securing the SRT stream. This ensures that only authorized users can access the stream."""

    trial: Optional[bool] = None
    r"""FastPix allows for a to trial the live stream for free. The duration of trial streams is five minutes. After five minutes of activity, the trial stream is turned off, and the recorded asset is removed after a day."""

    status: Optional[str] = None
    r"""The current live stream status can be one of four values:Idle, Preparing, Active or Disabled.The Idle status signifies that there isn't a broadcast in progress.The preparing status indicates that the stream is getting prepared. while, the Active status indicates that a broadcast is currently in progress. The Disabled status means that no more RTMPS streams can be published."""

    max_resolution: Annotated[Optional[str], pydantic.Field(alias="maxResolution")] = (
        None
    )
    r"""Max resolution can be used to control the maximum resolution your media is encoded, stored, and streamed at."""

    max_duration: Annotated[Optional[int], pydantic.Field(alias="maxDuration")] = None
    r"""The maximum duration in seconds that a live stream can have before it ends the stream."""

    created_at: Annotated[Optional[datetime], pydantic.Field(alias="createdAt")] = None
    r"""It is the moment when the stream was created Time the media was generated, defined as a localDateTime (UTC Time)."""

    reconnect_window: Annotated[
        Optional[int], pydantic.Field(alias="reconnectWindow")
    ] = 60
    r"""In case the software streaming the live, gets disrupted for any reason and gets disconnected from FastPix, the reconnect window specifies the time span FastPix will wait before ending the stream. Before starting the stream, you can set the reconnect window time which is up to 1800 seconds."""

    enable_recording: Annotated[
        Optional[bool], pydantic.Field(alias="enableRecording")
    ] = None
    r"""When set to true, the livestream will be recorded and stored for later viewing purposes. If set to false, the livestream will not be recorded."""

    media_policy: Annotated[Optional[str], pydantic.Field(alias="mediaPolicy")] = None
    r"""Determines whether the recorded stream should be publicly accessible or private in Live to VOD (Video on Demand)."""

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""

    enable_dvr_mode: Annotated[
        Optional[bool], pydantic.Field(alias="enableDvrMode")
    ] = None
    r"""Enables DVR (Digital Video Recorder) functionality for the live stream. When set to true, viewers can pause, rewind, and resume playback during the live broadcast. This allows time-shifted viewing of the stream while it is still ongoing."""

    playback_ids: Annotated[
        Optional[List[PlaybackIDResponse]], pydantic.Field(alias="playbackIds")
    ] = None
    r"""A collection of Playback ID objects utilized for crafting HLS playback urls."""

    media_ids: Annotated[Optional[List[str]], pydantic.Field(alias="mediaIds")] = None
    r"""A set of media IDs created after the livestream ends. (live to VOD)"""

    srt_playback_response: Annotated[
        Optional[SrtPlaybackResponse], pydantic.Field(alias="srtPlaybackResponse")
    ] = None
    r"""This object contains the livestream playback response details for SRT Protocol"""
