"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .drmidresponse import DrmIDResponse, DrmIDResponseTypedDict
from .pagination import Pagination, PaginationTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, QueryParamMetadata
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetDrmConfigurationRequestTypedDict(TypedDict):
    offset: NotRequired[int]
    r"""Offset determines the starting point for data retrieval within a paginated list."""
    limit: NotRequired[int]
    r"""Limit specifies the maximum number of items to display per page."""


class GetDrmConfigurationRequest(BaseModel):
    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Offset determines the starting point for data retrieval within a paginated list."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Limit specifies the maximum number of items to display per page."""


class GetDrmConfigurationResponseTypedDict(TypedDict):
    r"""DRM configuration(s) retrieved successfully"""

    success: NotRequired[bool]
    data: NotRequired[List[DrmIDResponseTypedDict]]
    pagination: NotRequired[PaginationTypedDict]
    r"""Pagination organizes content into pages for better readability and navigation."""


class GetDrmConfigurationResponse(BaseModel):
    r"""DRM configuration(s) retrieved successfully"""

    success: Optional[bool] = None

    data: Optional[List[DrmIDResponse]] = None

    pagination: Optional[Pagination] = None
    r"""Pagination organizes content into pages for better readability and navigation."""
