"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .metricsbreakdowndetails import (
    MetricsBreakdownDetails,
    MetricsBreakdownDetailsTypedDict,
)
from .metricstimeseriesmetadatadetails import (
    MetricsTimeseriesMetaDataDetails,
    MetricsTimeseriesMetaDataDetailsTypedDict,
)
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ListBreakdownValuesMetricID = Literal[
    "views",
    "unique_viewers",
    "playing_time",
    "quality_of_experience_score",
    "playback_score",
    "playback_failure_percentage",
    "exit_before_video_start",
    "video_startup_failure_percentage",
    "startup_score",
    "video_startup_time",
    "player_startup_time",
    "page_load_time",
    "total_startup_time",
    "live_stream_latency",
    "average_bitrate",
    "buffer_count",
    "render_quality_score",
    "avg_upscaling",
    "avg_downscaling",
    "max_upscaling",
    "max_downscaling",
    "jump_latency",
    "stability_score",
    "buffer_ratio",
    "buffer_frequency",
    "buffer_fill",
]
r"""Pass metric Id

"""


ListBreakdownValuesTimespan = Literal[
    "60:minutes",
    "6:hours",
    "24:hours",
    "3:days",
    "7:days",
    "30:days",
]
r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

"""


ListBreakdownValuesSortOrder = Literal[
    "asc",
    "desc",
]
r"""The order direction to sort the metrics list by.

"""


class ListBreakdownValuesRequestTypedDict(TypedDict):
    metric_id: ListBreakdownValuesMetricID
    r"""Pass metric Id

    """
    timespan: ListBreakdownValuesTimespan
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """
    filterby: NotRequired[str]
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """
    limit: NotRequired[int]
    r"""Pass the limit to display only the rows specified by the value.

    """
    offset: NotRequired[int]
    r"""Pass the offset value to indicate the page number.

    """
    group_by: NotRequired[str]
    r"""Pass this value to group the metrics list by.
    Possible Values : [\"browser_name\", \"browser_version\", \"os_name\",\"os_version\" , \"device_name\", \"device_model\", \"device_type\", \"device_manufacturer\", \"player_remote_played\",player_name\", \"player_version\", \"player_software_name\", \"player_software_version\", \"player_resolution\", \"fp_sdk\",\"fp_sdk_version\", \"player_autoplay_on\", \"player_preload_on\",\"video_title\",  \"video_id\", \"video_series\" ,  \"fp_playback_id\",\"fp_live_stream_id\", \"media_id\",\"video_source_stream_type\", \"video_source_type\", \"video_encoding_variant\", \"experiment_name\", \"sub_property_id\", \"drm_type\",\"asn_name\", \"cdn\", \"video_source_hostname\", \"connection_type\", \"view_session_id\",\"continent\",\"country\", \"region\",\"viewer_id\", \"error_code\", \"exit_before_video_start\", \"view_has_ad\", \"video_startup_failed\" , \"page_context\", \"playback_failed\".]

    """
    order_by: NotRequired[str]
    r"""Pass this value to order the metrics list by.

    """
    sort_order: NotRequired[ListBreakdownValuesSortOrder]
    r"""The order direction to sort the metrics list by.

    """
    measurement: NotRequired[str]
    r"""The measurement for the given metrics.

    """


class ListBreakdownValuesRequest(BaseModel):
    metric_id: Annotated[
        ListBreakdownValuesMetricID,
        pydantic.Field(alias="metricId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Pass metric Id

    """

    timespan: Annotated[
        ListBreakdownValuesTimespan,
        pydantic.Field(alias="timespan[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """

    filterby: Annotated[
        Optional[str],
        pydantic.Field(alias="filterby[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Pass the limit to display only the rows specified by the value.

    """

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Pass the offset value to indicate the page number.

    """

    group_by: Annotated[
        Optional[str],
        pydantic.Field(alias="groupBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Pass this value to group the metrics list by.
    Possible Values : [\"browser_name\", \"browser_version\", \"os_name\",\"os_version\" , \"device_name\", \"device_model\", \"device_type\", \"device_manufacturer\", \"player_remote_played\",player_name\", \"player_version\", \"player_software_name\", \"player_software_version\", \"player_resolution\", \"fp_sdk\",\"fp_sdk_version\", \"player_autoplay_on\", \"player_preload_on\",\"video_title\",  \"video_id\", \"video_series\" ,  \"fp_playback_id\",\"fp_live_stream_id\", \"media_id\",\"video_source_stream_type\", \"video_source_type\", \"video_encoding_variant\", \"experiment_name\", \"sub_property_id\", \"drm_type\",\"asn_name\", \"cdn\", \"video_source_hostname\", \"connection_type\", \"view_session_id\",\"continent\",\"country\", \"region\",\"viewer_id\", \"error_code\", \"exit_before_video_start\", \"view_has_ad\", \"video_startup_failed\" , \"page_context\", \"playback_failed\".]

    """

    order_by: Annotated[
        Optional[str],
        pydantic.Field(alias="orderBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "views"
    r"""Pass this value to order the metrics list by.

    """

    sort_order: Annotated[
        Optional[ListBreakdownValuesSortOrder],
        pydantic.Field(alias="sortOrder"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "asc"
    r"""The order direction to sort the metrics list by.

    """

    measurement: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "avg"
    r"""The measurement for the given metrics.

    """


class ListBreakdownValuesResponseTypedDict(TypedDict):
    r"""Get filter/ dimension value details by dimension name."""

    success: NotRequired[bool]
    r"""It demonstrates whether the request is successful or not."""
    meta_data: NotRequired[MetricsTimeseriesMetaDataDetailsTypedDict]
    r"""Retrieves breakdown values for a specified metric and timespan"""
    data: NotRequired[List[MetricsBreakdownDetailsTypedDict]]
    r"""Retrieves breakdown values for a specified metric and timespan"""
    timespan: NotRequired[List[int]]
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """


class ListBreakdownValuesResponse(BaseModel):
    r"""Get filter/ dimension value details by dimension name."""

    success: Optional[bool] = None
    r"""It demonstrates whether the request is successful or not."""

    meta_data: Annotated[
        Optional[MetricsTimeseriesMetaDataDetails], pydantic.Field(alias="metaData")
    ] = None
    r"""Retrieves breakdown values for a specified metric and timespan"""

    data: Optional[List[MetricsBreakdownDetails]] = None
    r"""Retrieves breakdown values for a specified metric and timespan"""

    timespan: Optional[List[int]] = None
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """
