"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .viewsbytopcontentdetails import (
    ViewsByTopContentDetails,
    ViewsByTopContentDetailsTypedDict,
)
from ..types import BaseModel
from ..utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ListByTopContentTimespan = Literal[
    "60:minutes",
    "6:hours",
    "24:hours",
    "3:days",
    "7:days",
    "30:days",
]
r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

"""


class ListByTopContentRequestTypedDict(TypedDict):
    timespan: ListByTopContentTimespan
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """
    filterby: NotRequired[str]
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """
    limit: NotRequired[int]
    r"""Pass the limit to display only the rows specified by the value.

    """


class ListByTopContentRequest(BaseModel):
    timespan: Annotated[
        ListByTopContentTimespan,
        pydantic.Field(alias="timespan[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """

    filterby: Annotated[
        Optional[str],
        pydantic.Field(alias="filterby[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Pass the limit to display only the rows specified by the value.

    """


class ListByTopContentResponseTypedDict(TypedDict):
    r"""Get the list of Views"""

    success: NotRequired[bool]
    r"""It demonstrates whether the request is successful or not."""
    data: NotRequired[List[ViewsByTopContentDetailsTypedDict]]
    r"""Displays the result of the request."""


class ListByTopContentResponse(BaseModel):
    r"""Get the list of Views"""

    success: Optional[bool] = None
    r"""It demonstrates whether the request is successful or not."""

    data: Optional[List[ViewsByTopContentDetails]] = None
    r"""Displays the result of the request."""
