"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .metricscomparisondetails import (
    MetricsComparisonDetails,
    MetricsComparisonDetailsTypedDict,
)
from ..types import BaseModel
from ..utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ListComparisonValuesTimespan = Literal[
    "60:minutes",
    "6:hours",
    "24:hours",
    "3:days",
    "7:days",
    "30:days",
]
r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

"""


ListComparisonValuesDimension = Literal[
    "browser_name",
    "browser_version",
    "os_name",
    "os_version",
    "device_name",
    "device_model",
    "device_type",
    "device_manufacturer",
    "player_remote_played",
    "player_name",
    "player_version",
    "player_software_name",
    "player_software_version",
    "player_resolution",
    "fp_sdk",
    "fp_sdk_version",
    "player_autoplay_on",
    "player_preload_on",
    "video_title",
    "video_id",
    "video_series",
    "fp_playback_id",
    "fp_live_stream_id",
    "media_id",
    "video_source_stream_type",
    "video_source_type",
    "video_encoding_variant",
    "experiment_name",
    "sub_property_id",
    "drm_type",
    "asn_name",
    "cdn",
    "video_source_hostname",
    "connection_type",
    "view_session_id",
    "continent",
    "country",
    "region",
    "viewer_id",
    "error_code",
    "exit_before_video_start",
    "view_has_ad",
    "video_startup_failed",
    "page_context",
    "playback_failed",
    "custom_1",
    "custom_2",
    "custom_3",
    "custom_4",
    "custom_5",
    "custom_6",
    "custom_7",
    "custom_8",
    "custom_9",
    "custom_10",
]
r"""The dimension id in which the views are watched.

"""


class ListComparisonValuesRequestTypedDict(TypedDict):
    timespan: ListComparisonValuesTimespan
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """
    filterby: NotRequired[str]
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """
    dimension: NotRequired[ListComparisonValuesDimension]
    r"""The dimension id in which the views are watched.

    """
    value: NotRequired[str]
    r"""The value for the selected dimension.
    For example:
    If `dimension` is `browser_name`, the value could be  `Chrome` `,` `Firefox` `etc` .
    If `dimension` is `os_name`, the value could be `macOS` `,` `Windows` `etc` .

    """


class ListComparisonValuesRequest(BaseModel):
    timespan: Annotated[
        ListComparisonValuesTimespan,
        pydantic.Field(alias="timespan[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """

    filterby: Annotated[
        Optional[str],
        pydantic.Field(alias="filterby[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """

    dimension: Annotated[
        Optional[ListComparisonValuesDimension],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The dimension id in which the views are watched.

    """

    value: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The value for the selected dimension.
    For example:
    If `dimension` is `browser_name`, the value could be  `Chrome` `,` `Firefox` `etc` .
    If `dimension` is `os_name`, the value could be `macOS` `,` `Windows` `etc` .

    """


class ListComparisonValuesResponseTypedDict(TypedDict):
    r"""Get filter/ dimension value details by dimension name."""

    success: NotRequired[bool]
    r"""It demonstrates whether the request is successful or not."""
    data: NotRequired[List[List[MetricsComparisonDetailsTypedDict]]]
    r"""Displays the result of the request.

    """
    timespan: NotRequired[List[int]]
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """


class ListComparisonValuesResponse(BaseModel):
    r"""Get filter/ dimension value details by dimension name."""

    success: Optional[bool] = None
    r"""It demonstrates whether the request is successful or not."""

    data: Optional[List[List[MetricsComparisonDetails]]] = None
    r"""Displays the result of the request.

    """

    timespan: Optional[List[int]] = None
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """
