"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .errordetails import ErrorDetails, ErrorDetailsTypedDict
from .toperrordetails import TopErrorDetails, TopErrorDetailsTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ListErrorsTimespan = Literal[
    "60:minutes",
    "6:hours",
    "24:hours",
    "3:days",
    "7:days",
    "30:days",
]
r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

"""


class ListErrorsRequestTypedDict(TypedDict):
    timespan: ListErrorsTimespan
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """
    filterby: NotRequired[str]
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """
    limit: NotRequired[int]
    r"""Pass the limit to display only the rows specified by the value for top errors.

    """


class ListErrorsRequest(BaseModel):
    timespan: Annotated[
        ListErrorsTimespan,
        pydantic.Field(alias="timespan[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """

    filterby: Annotated[
        Optional[str],
        pydantic.Field(alias="filterby[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Pass the limit to display only the rows specified by the value for top errors.

    """


class ListErrorsDataTypedDict(TypedDict):
    r"""Displays the result of the request."""

    errors: NotRequired[List[ErrorDetailsTypedDict]]
    r"""Retrieves a list of errors that have occurred in the system."""
    top_errors: NotRequired[List[TopErrorDetailsTypedDict]]
    r"""Retrieves a list of errors that have occurred most frequently in the system, ranked by their count of occurrences."""


class ListErrorsData(BaseModel):
    r"""Displays the result of the request."""

    errors: Optional[List[ErrorDetails]] = None
    r"""Retrieves a list of errors that have occurred in the system."""

    top_errors: Annotated[
        Optional[List[TopErrorDetails]], pydantic.Field(alias="topErrors")
    ] = None
    r"""Retrieves a list of errors that have occurred most frequently in the system, ranked by their count of occurrences."""


class ListErrorsResponseTypedDict(TypedDict):
    r"""Get filter/ dimension value details by dimension name."""

    success: NotRequired[bool]
    r"""It demonstrates whether the request is successful or not."""
    data: NotRequired[ListErrorsDataTypedDict]
    r"""Displays the result of the request."""
    timespan: NotRequired[List[int]]
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """


class ListErrorsResponse(BaseModel):
    r"""Get filter/ dimension value details by dimension name."""

    success: Optional[bool] = None
    r"""It demonstrates whether the request is successful or not."""

    data: Optional[ListErrorsData] = None
    r"""Displays the result of the request."""

    timespan: Optional[List[int]] = None
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """
