"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .browsernamedimensiondetails import (
    BrowserNameDimensiondetails,
    BrowserNameDimensiondetailsTypedDict,
)
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


DimensionsID = Literal[
    "browser_name",
    "browser_version",
    "os_name",
    "os_version",
    "device_name",
    "device_model",
    "device_type",
    "device_manufacturer",
    "player_remote_played",
    "player_name",
    "player_version",
    "player_software_name",
    "player_software_version",
    "player_resolution",
    "fp_sdk",
    "fp_sdk_version",
    "player_autoplay_on",
    "player_preload_on",
    "video_title",
    "video_id",
    "video_series",
    "fp_playback_id",
    "fp_live_stream_id",
    "media_id",
    "video_source_stream_type",
    "video_source_type",
    "video_encoding_variant",
    "experiment_name",
    "sub_property_id",
    "drm_type",
    "asn_name",
    "cdn",
    "video_source_hostname",
    "connection_type",
    "view_session_id",
    "continent",
    "country",
    "region",
    "viewer_id",
    "error_code",
    "exit_before_video_start",
    "view_has_ad",
    "video_startup_failed",
    "page_context",
    "playback_failed",
    "custom_1",
    "custom_2",
    "custom_3",
    "custom_4",
    "custom_5",
    "custom_6",
    "custom_7",
    "custom_8",
    "custom_9",
    "custom_10",
]
r"""Pass Dimensions id

"""


ListFilterValuesForDimensionTimespan = Literal[
    "60:minutes",
    "6:hours",
    "24:hours",
    "3:days",
    "7:days",
    "30:days",
]
r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

"""


class ListFilterValuesForDimensionRequestTypedDict(TypedDict):
    dimensions_id: DimensionsID
    r"""Pass Dimensions id

    """
    timespan: ListFilterValuesForDimensionTimespan
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """
    filterby: NotRequired[str]
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """


class ListFilterValuesForDimensionRequest(BaseModel):
    dimensions_id: Annotated[
        DimensionsID,
        pydantic.Field(alias="dimensionsId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Pass Dimensions id

    """

    timespan: Annotated[
        ListFilterValuesForDimensionTimespan,
        pydantic.Field(alias="timespan[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """

    filterby: Annotated[
        Optional[str],
        pydantic.Field(alias="filterby[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """


class ListFilterValuesForDimensionResponseTypedDict(TypedDict):
    r"""Get filter / dimension value details by dimension name."""

    success: NotRequired[bool]
    r"""It demonstrates whether the request is successful or not."""
    data: NotRequired[List[BrowserNameDimensiondetailsTypedDict]]
    r"""filter values associated with a specific dimension"""
    timespan: NotRequired[List[int]]
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """


class ListFilterValuesForDimensionResponse(BaseModel):
    r"""Get filter / dimension value details by dimension name."""

    success: Optional[bool] = None
    r"""It demonstrates whether the request is successful or not."""

    data: Optional[List[BrowserNameDimensiondetails]] = None
    r"""filter values associated with a specific dimension"""

    timespan: Optional[List[int]] = None
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """
