"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .metricsoveralldatadetails import (
    MetricsOverallDataDetails,
    MetricsOverallDataDetailsTypedDict,
)
from .metricsoverallmetadatadetails import (
    MetricsOverallMetaDataDetails,
    MetricsOverallMetaDataDetailsTypedDict,
)
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ListOverallValuesMetricID = Literal[
    "views",
    "unique_viewers",
    "playing_time",
    "quality_of_experience_score",
    "playback_score",
    "playback_failure_percentage",
    "exit_before_video_start",
    "video_startup_failure_percentage",
    "startup_score",
    "video_startup_time",
    "player_startup_time",
    "page_load_time",
    "total_startup_time",
    "live_stream_latency",
    "average_bitrate",
    "buffer_count",
    "render_quality_score",
    "avg_upscaling",
    "avg_downscaling",
    "max_upscaling",
    "max_downscaling",
    "jump_latency",
    "stability_score",
    "buffer_ratio",
    "buffer_frequency",
    "buffer_fill",
]
r"""Pass metric Id

"""


ListOverallValuesTimespan = Literal[
    "60:minutes",
    "6:hours",
    "24:hours",
    "3:days",
    "7:days",
    "30:days",
]
r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

"""


class ListOverallValuesRequestTypedDict(TypedDict):
    metric_id: ListOverallValuesMetricID
    r"""Pass metric Id

    """
    timespan: ListOverallValuesTimespan
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """
    measurement: NotRequired[str]
    r"""The measurement for the given metrics.
    Possible Values : [95th, median, avg, count or sum]

    """
    filterby: NotRequired[str]
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """


class ListOverallValuesRequest(BaseModel):
    metric_id: Annotated[
        ListOverallValuesMetricID,
        pydantic.Field(alias="metricId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Pass metric Id

    """

    timespan: Annotated[
        ListOverallValuesTimespan,
        pydantic.Field(alias="timespan[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """

    measurement: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "avg"
    r"""The measurement for the given metrics.
    Possible Values : [95th, median, avg, count or sum]

    """

    filterby: Annotated[
        Optional[str],
        pydantic.Field(alias="filterby[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """


class ListOverallValuesResponseTypedDict(TypedDict):
    r"""Get filter/ dimension value details by dimension name."""

    success: NotRequired[bool]
    r"""It demonstrates whether the request is successful or not."""
    meta_data: NotRequired[MetricsOverallMetaDataDetailsTypedDict]
    r"""Metadata that has to be paased for metric calculations."""
    data: NotRequired[MetricsOverallDataDetailsTypedDict]
    r"""Retrieves overall values for a specified metric"""
    timespan: NotRequired[List[int]]
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """


class ListOverallValuesResponse(BaseModel):
    r"""Get filter/ dimension value details by dimension name."""

    success: Optional[bool] = None
    r"""It demonstrates whether the request is successful or not."""

    meta_data: Annotated[
        Optional[MetricsOverallMetaDataDetails], pydantic.Field(alias="metaData")
    ] = None
    r"""Metadata that has to be paased for metric calculations."""

    data: Optional[MetricsOverallDataDetails] = None
    r"""Retrieves overall values for a specified metric"""

    timespan: Optional[List[int]] = None
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """
