"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .directupload import DirectUpload, DirectUploadTypedDict
from .pagination import Pagination, PaginationTypedDict
from .sortorder import SortOrder
from ..types import BaseModel
from ..utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListUploadsRequestTypedDict(TypedDict):
    limit: NotRequired[int]
    r"""Limit specifies the maximum number of items to display per page."""
    offset: NotRequired[int]
    r"""Offset determines the starting point for data retrieval within a paginated list."""
    order_by: NotRequired[SortOrder]
    r"""The values in the list can be arranged in two ways: DESC (Descending) or ASC (Ascending)."""


class ListUploadsRequest(BaseModel):
    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Limit specifies the maximum number of items to display per page."""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Offset determines the starting point for data retrieval within a paginated list."""

    order_by: Annotated[
        Optional[SortOrder],
        pydantic.Field(alias="orderBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "desc"
    r"""The values in the list can be arranged in two ways: DESC (Descending) or ASC (Ascending)."""


class ListUploadsResponseTypedDict(TypedDict):
    r"""List of video media"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[List[DirectUploadTypedDict]]
    r"""Displays the result of the request."""
    pagination: NotRequired[PaginationTypedDict]
    r"""Pagination organizes content into pages for better readability and navigation."""


class ListUploadsResponse(BaseModel):
    r"""List of video media"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[List[DirectUpload]] = None
    r"""Displays the result of the request."""

    pagination: Optional[Pagination] = None
    r"""Pagination organizes content into pages for better readability and navigation."""
