"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .datapagination import DataPagination, DataPaginationTypedDict
from .viewslist import ViewsList, ViewsListTypedDict
from ..types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from ..utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


ListVideoViewsTimespan = Literal[
    "60:minutes",
    "6:hours",
    "24:hours",
    "3:days",
    "7:days",
    "30:days",
]
r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

"""


ErrorCodeTypedDict = TypeAliasType("ErrorCodeTypedDict", Union[str, int])
r"""Pass the error code to filter the list of views. The possible values of error code can be fetched from list of errors end point.

"""


ErrorCode = TypeAliasType("ErrorCode", Union[str, int])
r"""Pass the error code to filter the list of views. The possible values of error code can be fetched from list of errors end point.

"""


class ListVideoViewsRequestTypedDict(TypedDict):
    timespan: ListVideoViewsTimespan
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """
    filterby: NotRequired[str]
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """
    limit: NotRequired[int]
    r"""Pass the limit to display only the rows specified by the value.

    """
    offset: NotRequired[int]
    r"""Pass the offset value to indicate the page number.

    """
    viewer_id: NotRequired[str]
    r"""Pass the viewer_id to filter the list of views. This value can be manually set during integration or generated by FastPix. When set manually it can be a string of aplha numeric values of any length.

    """
    error_code: NotRequired[Nullable[ErrorCodeTypedDict]]
    r"""Pass the error code to filter the list of views. The possible values of error code can be fetched from list of errors end point.

    """
    order_by: NotRequired[str]
    r"""Pass this value to sort the view list by.

    """
    sort_order: NotRequired[str]
    r"""The order direction to sort the view list by.

    """


class ListVideoViewsRequest(BaseModel):
    timespan: Annotated[
        ListVideoViewsTimespan,
        pydantic.Field(alias="timespan[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""This parameter specifies the time span between which the video views list should be retrieved by. You can provide either from and to unix epoch timestamps or time duration. The scope of duration is between 60 minutes to 30 days.

    """

    filterby: Annotated[
        Optional[str],
        pydantic.Field(alias="filterby[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Pass the dimensions and their corresponding values you want to filter the views by. For excluding the values in the filter we can pass '!' before the filter value. The list of filters can be obtained from list of dimensions endpoint.
    Example Values : [ browser_name:Chrome , os_name:macOS , device_name:Galaxy ]

    """

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Pass the limit to display only the rows specified by the value.

    """

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Pass the offset value to indicate the page number.

    """

    viewer_id: Annotated[
        Optional[str],
        pydantic.Field(alias="viewerId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Pass the viewer_id to filter the list of views. This value can be manually set during integration or generated by FastPix. When set manually it can be a string of aplha numeric values of any length.

    """

    error_code: Annotated[
        OptionalNullable[ErrorCode],
        pydantic.Field(alias="errorCode"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Pass the error code to filter the list of views. The possible values of error code can be fetched from list of errors end point.

    """

    order_by: Annotated[
        Optional[str],
        pydantic.Field(alias="orderBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "view_end"
    r"""Pass this value to sort the view list by.

    """

    sort_order: Annotated[
        Optional[str],
        pydantic.Field(alias="sortOrder"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "asc"
    r"""The order direction to sort the view list by.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "filterby[]",
            "limit",
            "offset",
            "viewerId",
            "errorCode",
            "orderBy",
            "sortOrder",
        ]
        nullable_fields = ["errorCode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListVideoViewsResponseTypedDict(TypedDict):
    r"""Get the list of Views"""

    success: NotRequired[bool]
    r"""It demonstrates whether the request is successful or not."""
    data: NotRequired[List[ViewsListTypedDict]]
    r"""Displays the result of the request."""
    pagination: NotRequired[DataPaginationTypedDict]
    r"""Pagination organizes content into pages for better readability and navigation."""
    timespan: NotRequired[List[int]]
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """


class ListVideoViewsResponse(BaseModel):
    r"""Get the list of Views"""

    success: Optional[bool] = None
    r"""It demonstrates whether the request is successful or not."""

    data: Optional[List[ViewsList]] = None
    r"""Displays the result of the request."""

    pagination: Optional[DataPagination] = None
    r"""Pagination organizes content into pages for better readability and navigation."""

    timespan: Optional[List[int]] = None
    r"""The timeframe from and to details displayed in the form of unix epoch timestamps.

    """
