"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .playbackid import PlaybackID, PlaybackIDTypedDict
from .track import Track, TrackTypedDict
from datetime import datetime
from ..types import BaseModel
import pydantic
from typing import Dict, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


MediaMaxResolution = Literal[
    "2160p",
    "1440p",
    "1080p",
    "720p",
    "480p",
    "360p",
]
r"""The maximum resolution specified by the user for the media."""


MediaSourceResolution = Literal[
    "2160p",
    "1440p",
    "1080p",
    "720p",
    "480p",
    "360p",
]
r"""The actual resolution of the uploaded media. This represents the native quality of the source media."""


MediaMp4Support = Literal[
    "none",
    "capped_4k",
    "audioOnly",
    "audioOnly,capped_4k",
]
r"""Determines the type of MP4 support for the media.   - **none**: Disables MP4 support.   - **capped_4k**: Enables MP4 downloads with resolutions up to 4K.   - **audioOnly**: Provides an MP4 stream containing only the audio.   - **audioOnly,capped_4k**: Enables both MP4 video downloads (up to 4K) and an audio-only stream."""


class MediaTypedDict(TypedDict):
    thumbnail: NotRequired[str]
    r"""A video thumbnail is a still image that acts as the preview image for your video."""
    id: NotRequired[str]
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""
    workspace_id: NotRequired[str]
    r"""A unique identifier is generated by FastPix for the workspace."""
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""
    max_resolution: NotRequired[MediaMaxResolution]
    r"""The maximum resolution specified by the user for the media."""
    source_resolution: NotRequired[MediaSourceResolution]
    r"""The actual resolution of the uploaded media. This represents the native quality of the source media."""
    status: NotRequired[str]
    r"""Determines the media's status, which can be one of the possible values."""
    mp4_support: NotRequired[MediaMp4Support]
    r"""Determines the type of MP4 support for the media.   - **none**: Disables MP4 support.   - **capped_4k**: Enables MP4 downloads with resolutions up to 4K.   - **audioOnly**: Provides an MP4 stream containing only the audio.   - **audioOnly,capped_4k**: Enables both MP4 video downloads (up to 4K) and an audio-only stream."""
    source_access: NotRequired[bool]
    r"""The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it"""
    playback_ids: NotRequired[List[PlaybackIDTypedDict]]
    r"""A collection of Playback ID objects utilized for crafting HLS playback URLs."""
    tracks: NotRequired[List[TrackTypedDict]]
    r"""A media consists of different media tracks, like video, audio, and subtitle, all combined."""
    duration: NotRequired[str]
    r"""The time span of the media, measured in seconds with a maximum allowable duration of 12 hours per individual media."""
    frame_rate: NotRequired[str]
    r"""Frame rate quantifies the speed at which frames are displayed per second. It represents the range of frames available for a specific track. If the frame rate of the input file is indeterminable, it will be indicated by a value of -1."""
    aspect_ratio: NotRequired[str]
    r"""The aspect ratio of a video is a value that describes the relative shape of a video based on its width and height."""
    created_at: NotRequired[datetime]
    r"""Time the media was created, defined as a localDateTime (UTC Time)."""
    updated_at: NotRequired[datetime]
    r"""Time the media was updated, defined as a localDateTime (UTC Time)."""


class Media(BaseModel):
    thumbnail: Optional[str] = None
    r"""A video thumbnail is a still image that acts as the preview image for your video."""

    id: Optional[str] = None
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""

    workspace_id: Annotated[Optional[str], pydantic.Field(alias="workspaceId")] = None
    r"""A unique identifier is generated by FastPix for the workspace."""

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""

    max_resolution: Annotated[
        Optional[MediaMaxResolution], pydantic.Field(alias="maxResolution")
    ] = "1080p"
    r"""The maximum resolution specified by the user for the media."""

    source_resolution: Annotated[
        Optional[MediaSourceResolution], pydantic.Field(alias="sourceResolution")
    ] = "1080p"
    r"""The actual resolution of the uploaded media. This represents the native quality of the source media."""

    status: Optional[str] = None
    r"""Determines the media's status, which can be one of the possible values."""

    mp4_support: Annotated[
        Optional[MediaMp4Support], pydantic.Field(alias="mp4Support")
    ] = None
    r"""Determines the type of MP4 support for the media.   - **none**: Disables MP4 support.   - **capped_4k**: Enables MP4 downloads with resolutions up to 4K.   - **audioOnly**: Provides an MP4 stream containing only the audio.   - **audioOnly,capped_4k**: Enables both MP4 video downloads (up to 4K) and an audio-only stream."""

    source_access: Annotated[Optional[bool], pydantic.Field(alias="sourceAccess")] = (
        None
    )
    r"""The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it"""

    playback_ids: Annotated[
        Optional[List[PlaybackID]], pydantic.Field(alias="playbackIds")
    ] = None
    r"""A collection of Playback ID objects utilized for crafting HLS playback URLs."""

    tracks: Optional[List[Track]] = None
    r"""A media consists of different media tracks, like video, audio, and subtitle, all combined."""

    duration: Optional[str] = None
    r"""The time span of the media, measured in seconds with a maximum allowable duration of 12 hours per individual media."""

    frame_rate: Annotated[Optional[str], pydantic.Field(alias="frameRate")] = None
    r"""Frame rate quantifies the speed at which frames are displayed per second. It represents the range of frames available for a specific track. If the frame rate of the input file is indeterminable, it will be indicated by a value of -1."""

    aspect_ratio: Annotated[Optional[str], pydantic.Field(alias="aspectRatio")] = None
    r"""The aspect ratio of a video is a value that describes the relative shape of a video based on its width and height."""

    created_at: Annotated[Optional[datetime], pydantic.Field(alias="createdAt")] = None
    r"""Time the media was created, defined as a localDateTime (UTC Time)."""

    updated_at: Annotated[Optional[datetime], pydantic.Field(alias="updatedAt")] = None
    r"""Time the media was updated, defined as a localDateTime (UTC Time)."""
