"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class MediaCancelResponseTypedDict(TypedDict):
    r"""Response returned when an upload is cancelled."""

    upload_id: NotRequired[str]
    r"""The unique identifier of the cancelled upload."""
    trial: NotRequired[bool]
    r"""Indicates if the upload was a trial."""
    status: NotRequired[str]
    r"""The status of the upload after cancellation."""
    url: NotRequired[str]
    r"""The upload URL (if available) after cancellation."""
    timeout: NotRequired[int]
    r"""The timeout value for the upload."""
    cors_origin: NotRequired[str]
    r"""CORS origin allowed for the upload."""
    max_resolution: NotRequired[str]
    r"""The maximum resolution allowed for the upload."""
    access_policy: NotRequired[str]
    r"""The access policy for the upload."""
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""


class MediaCancelResponse(BaseModel):
    r"""Response returned when an upload is cancelled."""

    upload_id: Annotated[Optional[str], pydantic.Field(alias="uploadId")] = None
    r"""The unique identifier of the cancelled upload."""

    trial: Optional[bool] = None
    r"""Indicates if the upload was a trial."""

    status: Optional[str] = None
    r"""The status of the upload after cancellation."""

    url: Optional[str] = None
    r"""The upload URL (if available) after cancellation."""

    timeout: Optional[int] = None
    r"""The timeout value for the upload."""

    cors_origin: Annotated[Optional[str], pydantic.Field(alias="corsOrigin")] = None
    r"""CORS origin allowed for the upload."""

    max_resolution: Annotated[Optional[str], pydantic.Field(alias="maxResolution")] = (
        None
    )
    r"""The maximum resolution allowed for the upload."""

    access_policy: Annotated[Optional[str], pydantic.Field(alias="accessPolicy")] = None
    r"""The access policy for the upload."""

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""
