"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from ..types import BaseModel
import pydantic
from typing import Dict, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


MediaClipResponseMaxResolution = Literal[
    "2160p",
    "1440p",
    "1080p",
    "720p",
    "480p",
    "360p",
]
r"""The maximum resolution specified for the media."""


MediaClipResponseSourceResolution = Literal[
    "2160p",
    "1440p",
    "1080p",
    "720p",
    "480p",
    "360p",
]
r"""The actual resolution of the uploaded media."""


Status = Literal[
    "preparing",
    "ready",
    "failed",
    "created",
]
r"""The current processing status of the media."""


class MediaClipResponseDomainsTypedDict(TypedDict):
    default_policy: NotRequired[str]
    allow: NotRequired[List[str]]
    deny: NotRequired[List[str]]


class MediaClipResponseDomains(BaseModel):
    default_policy: Annotated[Optional[str], pydantic.Field(alias="defaultPolicy")] = (
        None
    )

    allow: Optional[List[str]] = None

    deny: Optional[List[str]] = None


class MediaClipResponseUserAgentsTypedDict(TypedDict):
    default_policy: NotRequired[str]
    allow: NotRequired[List[str]]
    deny: NotRequired[List[str]]


class MediaClipResponseUserAgents(BaseModel):
    default_policy: Annotated[Optional[str], pydantic.Field(alias="defaultPolicy")] = (
        None
    )

    allow: Optional[List[str]] = None

    deny: Optional[List[str]] = None


class MediaClipResponseAccessRestrictionsTypedDict(TypedDict):
    domains: NotRequired[MediaClipResponseDomainsTypedDict]
    user_agents: NotRequired[MediaClipResponseUserAgentsTypedDict]


class MediaClipResponseAccessRestrictions(BaseModel):
    domains: Optional[MediaClipResponseDomains] = None

    user_agents: Annotated[
        Optional[MediaClipResponseUserAgents], pydantic.Field(alias="userAgents")
    ] = None


class MediaClipResponsePlaybackIDTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The unique identifier for playback."""
    access_policy: NotRequired[str]
    r"""The access policy of the playback."""
    access_restrictions: NotRequired[MediaClipResponseAccessRestrictionsTypedDict]


class MediaClipResponsePlaybackID(BaseModel):
    id: Optional[str] = None
    r"""The unique identifier for playback."""

    access_policy: Annotated[Optional[str], pydantic.Field(alias="accessPolicy")] = None
    r"""The access policy of the playback."""

    access_restrictions: Annotated[
        Optional[MediaClipResponseAccessRestrictions],
        pydantic.Field(alias="accessRestrictions"),
    ] = None


MediaClipResponseType = Literal[
    "video",
    "audio",
    "subtitle",
]
r"""The type of media track."""


class MediaClipResponseTrackTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The unique identifier for the media track."""
    type: NotRequired[MediaClipResponseType]
    r"""The type of media track."""
    width: NotRequired[int]
    r"""The width of the video track (applicable to video only)."""
    height: NotRequired[int]
    r"""The height of the video track (applicable to video only)."""
    status: NotRequired[str]
    r"""The current processing status of the track."""
    language_code: NotRequired[str]
    r"""The language code of the audio or subtitle track."""
    language_name: NotRequired[str]
    r"""The language name of the audio or subtitle track."""


class MediaClipResponseTrack(BaseModel):
    id: Optional[str] = None
    r"""The unique identifier for the media track."""

    type: Optional[MediaClipResponseType] = None
    r"""The type of media track."""

    width: Optional[int] = None
    r"""The width of the video track (applicable to video only)."""

    height: Optional[int] = None
    r"""The height of the video track (applicable to video only)."""

    status: Optional[str] = None
    r"""The current processing status of the track."""

    language_code: Annotated[Optional[str], pydantic.Field(alias="languageCode")] = None
    r"""The language code of the audio or subtitle track."""

    language_name: Annotated[Optional[str], pydantic.Field(alias="languageName")] = None
    r"""The language name of the audio or subtitle track."""


class GeneratedSubtitleTypedDict(TypedDict):
    pass


class GeneratedSubtitle(BaseModel):
    pass


class MediaClipResponseDataTypedDict(TypedDict):
    thumbnail: NotRequired[str]
    r"""A video thumbnail that acts as a preview image for the video."""
    id: NotRequired[str]
    r"""The unique identifier assigned to the media by FastPix."""
    source_media_id: NotRequired[str]
    r"""The ID of the original source media."""
    workspace_id: NotRequired[str]
    r"""The unique identifier for the workspace associated with the media."""
    metadata: NotRequired[Dict[str, str]]
    r"""Tag a video in \"key\" : \"value\" pairs for searchable metadata. Maximum 10 entries, 255 characters each."""
    max_resolution: NotRequired[MediaClipResponseMaxResolution]
    r"""The maximum resolution specified for the media."""
    source_resolution: NotRequired[MediaClipResponseSourceResolution]
    r"""The actual resolution of the uploaded media."""
    status: NotRequired[Status]
    r"""The current processing status of the media."""
    source_access: NotRequired[bool]
    r"""Indicates whether the original media file is accessible."""
    playback_ids: NotRequired[List[MediaClipResponsePlaybackIDTypedDict]]
    tracks: NotRequired[List[MediaClipResponseTrackTypedDict]]
    generated_subtitles: NotRequired[List[GeneratedSubtitleTypedDict]]
    r"""Generated subtitle tracks associated with the media."""
    is_audio_only: NotRequired[bool]
    r"""Indicates whether the media contains only audio."""
    subtitle_available: NotRequired[bool]
    r"""Indicates whether subtitles are available for the media."""
    duration: NotRequired[str]
    r"""The total duration of the media."""
    aspect_ratio: NotRequired[str]
    r"""The aspect ratio of the media."""
    created_at: NotRequired[datetime]
    r"""Timestamp of when the media was created."""
    updated_at: NotRequired[datetime]
    r"""Timestamp of when the media was last updated."""


class MediaClipResponseData(BaseModel):
    thumbnail: Optional[str] = None
    r"""A video thumbnail that acts as a preview image for the video."""

    id: Optional[str] = None
    r"""The unique identifier assigned to the media by FastPix."""

    source_media_id: Annotated[Optional[str], pydantic.Field(alias="sourceMediaId")] = (
        None
    )
    r"""The ID of the original source media."""

    workspace_id: Annotated[Optional[str], pydantic.Field(alias="workspaceId")] = None
    r"""The unique identifier for the workspace associated with the media."""

    metadata: Optional[Dict[str, str]] = None
    r"""Tag a video in \"key\" : \"value\" pairs for searchable metadata. Maximum 10 entries, 255 characters each."""

    max_resolution: Annotated[
        Optional[MediaClipResponseMaxResolution], pydantic.Field(alias="maxResolution")
    ] = None
    r"""The maximum resolution specified for the media."""

    source_resolution: Annotated[
        Optional[MediaClipResponseSourceResolution],
        pydantic.Field(alias="sourceResolution"),
    ] = None
    r"""The actual resolution of the uploaded media."""

    status: Optional[Status] = None
    r"""The current processing status of the media."""

    source_access: Annotated[Optional[bool], pydantic.Field(alias="sourceAccess")] = (
        None
    )
    r"""Indicates whether the original media file is accessible."""

    playback_ids: Annotated[
        Optional[List[MediaClipResponsePlaybackID]], pydantic.Field(alias="playbackIds")
    ] = None

    tracks: Optional[List[MediaClipResponseTrack]] = None

    generated_subtitles: Annotated[
        Optional[List[GeneratedSubtitle]], pydantic.Field(alias="generatedSubtitles")
    ] = None
    r"""Generated subtitle tracks associated with the media."""

    is_audio_only: Annotated[Optional[bool], pydantic.Field(alias="isAudioOnly")] = None
    r"""Indicates whether the media contains only audio."""

    subtitle_available: Annotated[
        Optional[bool], pydantic.Field(alias="subtitleAvailable")
    ] = None
    r"""Indicates whether subtitles are available for the media."""

    duration: Optional[str] = None
    r"""The total duration of the media."""

    aspect_ratio: Annotated[Optional[str], pydantic.Field(alias="aspectRatio")] = None
    r"""The aspect ratio of the media."""

    created_at: Annotated[Optional[datetime], pydantic.Field(alias="createdAt")] = None
    r"""Timestamp of when the media was created."""

    updated_at: Annotated[Optional[datetime], pydantic.Field(alias="updatedAt")] = None
    r"""Timestamp of when the media was last updated."""


class MediaClipResponsePaginationTypedDict(TypedDict):
    total_records: NotRequired[int]
    r"""Total number of records available."""
    current_offset: NotRequired[int]
    r"""The starting offset of the current result set."""
    offset_count: NotRequired[int]
    r"""The number of items returned in the current response."""


class MediaClipResponsePagination(BaseModel):
    total_records: Annotated[Optional[int], pydantic.Field(alias="totalRecords")] = None
    r"""Total number of records available."""

    current_offset: Annotated[Optional[int], pydantic.Field(alias="currentOffset")] = (
        None
    )
    r"""The starting offset of the current result set."""

    offset_count: Annotated[Optional[int], pydantic.Field(alias="offsetCount")] = None
    r"""The number of items returned in the current response."""


class MediaClipResponseTypedDict(TypedDict):
    success: bool
    data: List[MediaClipResponseDataTypedDict]
    pagination: MediaClipResponsePaginationTypedDict


class MediaClipResponse(BaseModel):
    success: bool

    data: List[MediaClipResponseData]

    pagination: MediaClipResponsePagination
