"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


MetricsBreakdownDetailsValueTypedDict = TypeAliasType(
    "MetricsBreakdownDetailsValueTypedDict", Union[int, float]
)
r"""The specific metric value calculated based on the applied filters."""


MetricsBreakdownDetailsValue = TypeAliasType(
    "MetricsBreakdownDetailsValue", Union[int, float]
)
r"""The specific metric value calculated based on the applied filters."""


class MetricsBreakdownDetailsTypedDict(TypedDict):
    value: Nullable[MetricsBreakdownDetailsValueTypedDict]
    r"""The specific metric value calculated based on the applied filters."""
    views: NotRequired[Nullable[int]]
    r"""Total count of view sessions for a paricular video content."""
    total_watch_time: NotRequired[Nullable[int]]
    r"""Total time watched across all views, represented in milliseconds."""
    total_playing_time: NotRequired[Nullable[int]]
    r"""Total time spent playing the video, represented in milliseconds."""
    field: NotRequired[Nullable[str]]
    r"""the value of dimension or filter value on which the aggregation is to be applied."""


class MetricsBreakdownDetails(BaseModel):
    value: Nullable[MetricsBreakdownDetailsValue]
    r"""The specific metric value calculated based on the applied filters."""

    views: OptionalNullable[int] = UNSET
    r"""Total count of view sessions for a paricular video content."""

    total_watch_time: Annotated[
        OptionalNullable[int], pydantic.Field(alias="totalWatchTime")
    ] = UNSET
    r"""Total time watched across all views, represented in milliseconds."""

    total_playing_time: Annotated[
        OptionalNullable[int], pydantic.Field(alias="totalPlayingTime")
    ] = UNSET
    r"""Total time spent playing the video, represented in milliseconds."""

    field: OptionalNullable[str] = UNSET
    r"""the value of dimension or filter value on which the aggregation is to be applied."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["views", "totalWatchTime", "totalPlayingTime", "field"]
        nullable_fields = [
            "views",
            "value",
            "totalWatchTime",
            "totalPlayingTime",
            "field",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
