"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


MetricsOverallDataDetailsValueTypedDict = TypeAliasType(
    "MetricsOverallDataDetailsValueTypedDict", Union[int, float]
)
r"""metric value calculated based on the applied filters."""


MetricsOverallDataDetailsValue = TypeAliasType(
    "MetricsOverallDataDetailsValue", Union[int, float]
)
r"""metric value calculated based on the applied filters."""


GlobalValueTypedDict = TypeAliasType("GlobalValueTypedDict", Union[int, float])
r"""A global metric value that reflects the overall performance of the specified metric across the entire dataset for the given timespan."""


GlobalValue = TypeAliasType("GlobalValue", Union[int, float])
r"""A global metric value that reflects the overall performance of the specified metric across the entire dataset for the given timespan."""


class MetricsOverallDataDetailsTypedDict(TypedDict):
    r"""Retrieves overall values for a specified metric"""

    value: NotRequired[Nullable[MetricsOverallDataDetailsValueTypedDict]]
    r"""metric value calculated based on the applied filters."""
    total_watch_time: NotRequired[Nullable[int]]
    r"""Total time watched across all views, represented in milliseconds."""
    unique_views: NotRequired[Nullable[int]]
    r"""The count of unique viewers who interacted with the content."""
    total_views: NotRequired[Nullable[int]]
    r"""The total number of views recorded."""
    total_play_time: NotRequired[Nullable[int]]
    r"""Total time spent playing the video, represented in milliseconds."""
    global_value: NotRequired[Nullable[GlobalValueTypedDict]]
    r"""A global metric value that reflects the overall performance of the specified metric across the entire dataset for the given timespan."""


class MetricsOverallDataDetails(BaseModel):
    r"""Retrieves overall values for a specified metric"""

    value: OptionalNullable[MetricsOverallDataDetailsValue] = UNSET
    r"""metric value calculated based on the applied filters."""

    total_watch_time: Annotated[
        OptionalNullable[int], pydantic.Field(alias="totalWatchTime")
    ] = UNSET
    r"""Total time watched across all views, represented in milliseconds."""

    unique_views: Annotated[
        OptionalNullable[int], pydantic.Field(alias="uniqueViews")
    ] = UNSET
    r"""The count of unique viewers who interacted with the content."""

    total_views: Annotated[
        OptionalNullable[int], pydantic.Field(alias="totalViews")
    ] = UNSET
    r"""The total number of views recorded."""

    total_play_time: Annotated[
        OptionalNullable[int], pydantic.Field(alias="totalPlayTime")
    ] = UNSET
    r"""Total time spent playing the video, represented in milliseconds."""

    global_value: Annotated[
        OptionalNullable[GlobalValue], pydantic.Field(alias="globalValue")
    ] = UNSET
    r"""A global metric value that reflects the overall performance of the specified metric across the entire dataset for the given timespan."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "value",
            "totalWatchTime",
            "uniqueViews",
            "totalViews",
            "totalPlayTime",
            "globalValue",
        ]
        nullable_fields = [
            "value",
            "totalWatchTime",
            "uniqueViews",
            "totalViews",
            "totalPlayTime",
            "globalValue",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
