"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from ..types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


MetricValueTypedDict = TypeAliasType("MetricValueTypedDict", Union[int, float])
r"""The value of the specified metric at the given interval."""


MetricValue = TypeAliasType("MetricValue", Union[int, float])
r"""The value of the specified metric at the given interval."""


class MetricsTimeseriesDataDetailsTypedDict(TypedDict):
    r"""The metric's value at specific time intervals."""

    interval_time: NotRequired[datetime]
    r"""The timestamp for the data point indicating when the metric value was recorded."""
    metric_value: NotRequired[Nullable[MetricValueTypedDict]]
    r"""The value of the specified metric at the given interval."""
    number_of_views: NotRequired[Nullable[int]]
    r"""The total number of views recorded during that interval."""


class MetricsTimeseriesDataDetails(BaseModel):
    r"""The metric's value at specific time intervals."""

    interval_time: Annotated[
        Optional[datetime], pydantic.Field(alias="intervalTime")
    ] = None
    r"""The timestamp for the data point indicating when the metric value was recorded."""

    metric_value: Annotated[
        OptionalNullable[MetricValue], pydantic.Field(alias="metricValue")
    ] = UNSET
    r"""The value of the specified metric at the given interval."""

    number_of_views: Annotated[
        OptionalNullable[int], pydantic.Field(alias="numberOfViews")
    ] = UNSET
    r"""The total number of views recorded during that interval."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["intervalTime", "metricValue", "numberOfViews"]
        nullable_fields = ["metricValue", "numberOfViews"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
