"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .accesspolicy import AccessPolicy
from .policyaction import PolicyAction
from ..types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PlaybackIDDomainsTypedDict(TypedDict):
    r"""Restrictions based on the originating domain of a request (e.g., whether requests from certain websites should be allowed or blocked)."""

    default_policy: NotRequired[PolicyAction]
    r"""Policy action type"""
    allow: NotRequired[List[str]]
    r"""A list of domains that are explicitly allowed access."""
    deny: NotRequired[List[str]]
    r"""A list of domains that are explicitly blocked from accessing the resource."""


class PlaybackIDDomains(BaseModel):
    r"""Restrictions based on the originating domain of a request (e.g., whether requests from certain websites should be allowed or blocked)."""

    default_policy: Annotated[
        Optional[PolicyAction], pydantic.Field(alias="defaultPolicy")
    ] = None
    r"""Policy action type"""

    allow: Optional[List[str]] = None
    r"""A list of domains that are explicitly allowed access."""

    deny: Optional[List[str]] = None
    r"""A list of domains that are explicitly blocked from accessing the resource."""


class PlaybackIDUserAgentsTypedDict(TypedDict):
    r"""Restrictions based on the user agent (which is typically a string sent by browsers or bots identifying themselves)."""

    default_policy: NotRequired[PolicyAction]
    r"""Policy action type"""
    allow: NotRequired[List[str]]
    r"""A list of specific user agents that are allowed to access the resource."""
    deny: NotRequired[List[str]]
    r"""A list of specific user agents that are blocked."""


class PlaybackIDUserAgents(BaseModel):
    r"""Restrictions based on the user agent (which is typically a string sent by browsers or bots identifying themselves)."""

    default_policy: Annotated[
        Optional[PolicyAction], pydantic.Field(alias="defaultPolicy")
    ] = None
    r"""Policy action type"""

    allow: Optional[List[str]] = None
    r"""A list of specific user agents that are allowed to access the resource."""

    deny: Optional[List[str]] = None
    r"""A list of specific user agents that are blocked."""


class PlaybackIDAccessRestrictionsTypedDict(TypedDict):
    r"""Controls access based on domains and user agents. Defines a default policy (either \"allow\" or \"deny\") and provides lists for explicitly allowed or denied domains and user agents."""

    domains: NotRequired[PlaybackIDDomainsTypedDict]
    r"""Restrictions based on the originating domain of a request (e.g., whether requests from certain websites should be allowed or blocked)."""
    user_agents: NotRequired[PlaybackIDUserAgentsTypedDict]
    r"""Restrictions based on the user agent (which is typically a string sent by browsers or bots identifying themselves)."""


class PlaybackIDAccessRestrictions(BaseModel):
    r"""Controls access based on domains and user agents. Defines a default policy (either \"allow\" or \"deny\") and provides lists for explicitly allowed or denied domains and user agents."""

    domains: Optional[PlaybackIDDomains] = None
    r"""Restrictions based on the originating domain of a request (e.g., whether requests from certain websites should be allowed or blocked)."""

    user_agents: Annotated[
        Optional[PlaybackIDUserAgents], pydantic.Field(alias="userAgents")
    ] = None
    r"""Restrictions based on the user agent (which is typically a string sent by browsers or bots identifying themselves)."""


class PlaybackIDTypedDict(TypedDict):
    r"""A collection of Playback ID objects utilized for crafting HLS playback urls."""

    id: NotRequired[str]
    r"""A unique identifier is generated by FastPix for the playbacks."""
    access_policy: NotRequired[AccessPolicy]
    r"""Access policy for media content"""
    access_restrictions: NotRequired[PlaybackIDAccessRestrictionsTypedDict]
    r"""Controls access based on domains and user agents. Defines a default policy (either \"allow\" or \"deny\") and provides lists for explicitly allowed or denied domains and user agents."""


class PlaybackID(BaseModel):
    r"""A collection of Playback ID objects utilized for crafting HLS playback urls."""

    id: Optional[str] = None
    r"""A unique identifier is generated by FastPix for the playbacks."""

    access_policy: Annotated[
        Optional[AccessPolicy], pydantic.Field(alias="accessPolicy")
    ] = None
    r"""Access policy for media content"""

    access_restrictions: Annotated[
        Optional[PlaybackIDAccessRestrictions],
        pydantic.Field(alias="accessRestrictions"),
    ] = None
    r"""Controls access based on domains and user agents. Defines a default policy (either \"allow\" or \"deny\") and provides lists for explicitly allowed or denied domains and user agents."""
