"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from ..types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


PlaylistByIDResponseType = Literal[
    "manual",
    "smart",
]
r"""type of the playlist, when it was created"""


class PlaylistByIDResponseMediaListTypedDict(TypedDict):
    created_at: NotRequired[datetime]
    r"""Timestamp of media creation in the workspace."""
    duration: NotRequired[str]
    r"""Duration of the media in hh:mm:ss format."""
    id: NotRequired[str]
    r"""unique id of the particular media."""
    source_resolution: NotRequired[str]
    r"""source resolution of the media."""
    status: NotRequired[str]
    r"""status of the media, only media with ready status will be added to playlist."""
    thumbnail: NotRequired[str]
    r"""thumbnail for the particular media."""


class PlaylistByIDResponseMediaList(BaseModel):
    created_at: Annotated[Optional[datetime], pydantic.Field(alias="createdAt")] = None
    r"""Timestamp of media creation in the workspace."""

    duration: Optional[str] = None
    r"""Duration of the media in hh:mm:ss format."""

    id: Optional[str] = None
    r"""unique id of the particular media."""

    source_resolution: Annotated[
        Optional[str], pydantic.Field(alias="sourceResolution")
    ] = None
    r"""source resolution of the media."""

    status: Optional[str] = None
    r"""status of the media, only media with ready status will be added to playlist."""

    thumbnail: Optional[str] = None
    r"""thumbnail for the particular media."""


class PlaylistByIDResponseDataTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The unique id of the playlist"""
    name: NotRequired[str]
    r"""The name of the playlist set by the user"""
    reference_id: NotRequired[str]
    r"""Unique string value assigned by user to the playlist."""
    type: NotRequired[PlaylistByIDResponseType]
    r"""type of the playlist, when it was created"""
    description: NotRequired[str]
    r"""Description of the playlist set by the user."""
    media_list: NotRequired[List[PlaylistByIDResponseMediaListTypedDict]]
    workspace_id: NotRequired[str]
    r"""The unique id of the workspace in which the playlist is present."""
    created_at: NotRequired[datetime]
    r"""Timestamp of playlist creation."""
    updated_at: NotRequired[datetime]
    r"""Playlist's most recent update timestamp."""
    media_count: NotRequired[int]
    r"""No. of media present in the playlist"""


class PlaylistByIDResponseData(BaseModel):
    id: Optional[str] = None
    r"""The unique id of the playlist"""

    name: Optional[str] = None
    r"""The name of the playlist set by the user"""

    reference_id: Annotated[Optional[str], pydantic.Field(alias="referenceId")] = None
    r"""Unique string value assigned by user to the playlist."""

    type: Optional[PlaylistByIDResponseType] = None
    r"""type of the playlist, when it was created"""

    description: Optional[str] = None
    r"""Description of the playlist set by the user."""

    media_list: Annotated[
        Optional[List[PlaylistByIDResponseMediaList]], pydantic.Field(alias="mediaList")
    ] = None

    workspace_id: Annotated[Optional[str], pydantic.Field(alias="workspaceId")] = None
    r"""The unique id of the workspace in which the playlist is present."""

    created_at: Annotated[Optional[datetime], pydantic.Field(alias="createdAt")] = None
    r"""Timestamp of playlist creation."""

    updated_at: Annotated[Optional[datetime], pydantic.Field(alias="updatedAt")] = None
    r"""Playlist's most recent update timestamp."""

    media_count: Annotated[Optional[int], pydantic.Field(alias="mediaCount")] = None
    r"""No. of media present in the playlist"""


class PlaylistByIDResponseTypedDict(TypedDict):
    success: NotRequired[bool]
    data: NotRequired[PlaylistByIDResponseDataTypedDict]


class PlaylistByIDResponse(BaseModel):
    success: Optional[bool] = None

    data: Optional[PlaylistByIDResponseData] = None
