"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .daterange import DateRange, DateRangeTypedDict
from .playlistorder import PlaylistOrder
from datetime import datetime
from ..types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


PlaylistCreatedSchemaType = Literal[
    "smart",
    "manual",
]
r"""Type will be either smart or manual, as sent in the request body."""


class PlaylistCreatedSchemaMetadataTypedDict(TypedDict):
    r"""date range filter used when creating the smart playlist"""

    created_date: NotRequired[DateRangeTypedDict]
    r"""Date range with start and end dates."""
    updated_date: NotRequired[DateRangeTypedDict]
    r"""Date range with start and end dates."""


class PlaylistCreatedSchemaMetadata(BaseModel):
    r"""date range filter used when creating the smart playlist"""

    created_date: Annotated[
        Optional[DateRange], pydantic.Field(alias="createdDate")
    ] = None
    r"""Date range with start and end dates."""

    updated_date: Annotated[
        Optional[DateRange], pydantic.Field(alias="updatedDate")
    ] = None
    r"""Date range with start and end dates."""


class PlaylistCreatedSchemaMediaListTypedDict(TypedDict):
    created_at: NotRequired[datetime]
    r"""timestamp of media creation in the workspace"""
    duration: NotRequired[str]
    r"""duration of the media in hh:mm:ss format"""
    id: NotRequired[str]
    r"""unique identifier of the media"""
    source_resolution: NotRequired[str]
    r"""The source resolution of the media"""
    status: NotRequired[str]
    r"""The status of the video in the workspace. Only media which are in ready status are added into the playlist"""
    thumbnail: NotRequired[str]
    r"""Thumbnail to the particular media"""


class PlaylistCreatedSchemaMediaList(BaseModel):
    created_at: Annotated[Optional[datetime], pydantic.Field(alias="createdAt")] = None
    r"""timestamp of media creation in the workspace"""

    duration: Optional[str] = None
    r"""duration of the media in hh:mm:ss format"""

    id: Optional[str] = None
    r"""unique identifier of the media"""

    source_resolution: Annotated[
        Optional[str], pydantic.Field(alias="sourceResolution")
    ] = None
    r"""The source resolution of the media"""

    status: Optional[str] = None
    r"""The status of the video in the workspace. Only media which are in ready status are added into the playlist"""

    thumbnail: Optional[str] = None
    r"""Thumbnail to the particular media"""


class PlaylistCreatedSchemaTypedDict(TypedDict):
    r"""Displays the result of the request."""

    id: NotRequired[str]
    r"""Upon creating a new play,ist, FastPix assigns a unique identifier to the playlist."""
    name: NotRequired[str]
    r"""The name to the playlist set by the user."""
    reference_id: NotRequired[str]
    r"""Unique string value assigned by user to the playlist."""
    type: NotRequired[PlaylistCreatedSchemaType]
    r"""Type will be either smart or manual, as sent in the request body."""
    description: NotRequired[str]
    r"""The description to the playlist set by the user."""
    play_order: NotRequired[PlaylistOrder]
    r"""Determines the insertion order of media into playlist."""
    metadata: NotRequired[PlaylistCreatedSchemaMetadataTypedDict]
    r"""date range filter used when creating the smart playlist"""
    media_list: NotRequired[List[PlaylistCreatedSchemaMediaListTypedDict]]
    workspace_id: NotRequired[str]
    r"""Id of the workspace"""
    created_at: NotRequired[datetime]
    r"""Timestamp of playlist creation."""
    updated_at: NotRequired[datetime]
    r"""Playlist's most recent update timestamp."""
    media_count: NotRequired[int]
    r"""No. of media present in the playlist"""


class PlaylistCreatedSchema(BaseModel):
    r"""Displays the result of the request."""

    id: Optional[str] = None
    r"""Upon creating a new play,ist, FastPix assigns a unique identifier to the playlist."""

    name: Optional[str] = None
    r"""The name to the playlist set by the user."""

    reference_id: Annotated[Optional[str], pydantic.Field(alias="referenceId")] = None
    r"""Unique string value assigned by user to the playlist."""

    type: Optional[PlaylistCreatedSchemaType] = None
    r"""Type will be either smart or manual, as sent in the request body."""

    description: Optional[str] = None
    r"""The description to the playlist set by the user."""

    play_order: Annotated[
        Optional[PlaylistOrder], pydantic.Field(alias="playOrder")
    ] = None
    r"""Determines the insertion order of media into playlist."""

    metadata: Optional[PlaylistCreatedSchemaMetadata] = None
    r"""date range filter used when creating the smart playlist"""

    media_list: Annotated[
        Optional[List[PlaylistCreatedSchemaMediaList]],
        pydantic.Field(alias="mediaList"),
    ] = None

    workspace_id: Annotated[Optional[str], pydantic.Field(alias="workspaceId")] = None
    r"""Id of the workspace"""

    created_at: Annotated[Optional[datetime], pydantic.Field(alias="createdAt")] = None
    r"""Timestamp of playlist creation."""

    updated_at: Annotated[Optional[datetime], pydantic.Field(alias="updatedAt")] = None
    r"""Playlist's most recent update timestamp."""

    media_count: Annotated[Optional[int], pydantic.Field(alias="mediaCount")] = None
    r"""No. of media present in the playlist"""
