"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SimulcastRequestTypedDict(TypedDict):
    url: NotRequired[str]
    r"""The RTMPS hostname, combined with the application name, is crucial for connecting to third-party live streaming services and transmitting the live stream."""
    stream_key: NotRequired[str]
    r"""A unique stream key is generated for streaming, allowing the user to start streaming on any third-party platform using this key."""
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""


class SimulcastRequest(BaseModel):
    url: Optional[str] = None
    r"""The RTMPS hostname, combined with the application name, is crucial for connecting to third-party live streaming services and transmitting the live stream."""

    stream_key: Annotated[Optional[str], pydantic.Field(alias="streamKey")] = None
    r"""A unique stream key is generated for streaming, allowing the user to start streaming on any third-party platform using this key."""

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""
