"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SimulcastResponseDataTypedDict(TypedDict):
    r"""Displays the result of the request."""

    simulcast_id: NotRequired[str]
    r"""When you create the new simulcast, FastPix assign a universal unique identifier which can contain a maximum of 255 characters."""
    url: NotRequired[str]
    r"""The RTMPS hostname, combined with the application name, is crucial for connecting to third-party live streaming services and transmitting the live stream."""
    stream_key: NotRequired[str]
    r"""A unique stream key is generated for streaming, allowing the user to start streaming on any third-party platform using this key."""
    is_enabled: NotRequired[bool]
    r"""When the value is true, the simulcast will be enabled for the given stream"""
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""


class SimulcastResponseData(BaseModel):
    r"""Displays the result of the request."""

    simulcast_id: Annotated[Optional[str], pydantic.Field(alias="simulcastId")] = None
    r"""When you create the new simulcast, FastPix assign a universal unique identifier which can contain a maximum of 255 characters."""

    url: Optional[str] = None
    r"""The RTMPS hostname, combined with the application name, is crucial for connecting to third-party live streaming services and transmitting the live stream."""

    stream_key: Annotated[Optional[str], pydantic.Field(alias="streamKey")] = None
    r"""A unique stream key is generated for streaming, allowing the user to start streaming on any third-party platform using this key."""

    is_enabled: Annotated[Optional[bool], pydantic.Field(alias="isEnabled")] = None
    r"""When the value is true, the simulcast will be enabled for the given stream"""

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""


class SimulcastResponseTypedDict(TypedDict):
    r"""Displays the result of the request."""

    success: NotRequired[bool]
    r"""It demonstrates whether the request is successful or not."""
    data: NotRequired[SimulcastResponseDataTypedDict]
    r"""Displays the result of the request."""


class SimulcastResponse(BaseModel):
    r"""Displays the result of the request."""

    success: Optional[bool] = None
    r"""It demonstrates whether the request is successful or not."""

    data: Optional[SimulcastResponseData] = None
    r"""Displays the result of the request."""
