"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SrtPlaybackResponseTypedDict(TypedDict):
    r"""This object contains the livestream playback response details for SRT Protocol"""

    srt_playback_stream_id: NotRequired[str]
    r"""A unique identifier for the SRT playback stream. This ID is used to distinguish between different playback streams"""
    srt_playback_secret: NotRequired[str]
    r"""A playback secret used for securing the SRT playback stream. This ensures that only authorized users can access the playback"""


class SrtPlaybackResponse(BaseModel):
    r"""This object contains the livestream playback response details for SRT Protocol"""

    srt_playback_stream_id: Annotated[
        Optional[str], pydantic.Field(alias="srtPlaybackStreamId")
    ] = None
    r"""A unique identifier for the SRT playback stream. This ID is used to distinguish between different playback streams"""

    srt_playback_secret: Annotated[
        Optional[str], pydantic.Field(alias="srtPlaybackSecret")
    ] = None
    r"""A playback secret used for securing the SRT playback stream. This ensures that only authorized users can access the playback"""
