"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .languagecode import LanguageCode
from ..types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class SubtitleInputTypedDict(TypedDict):
    r"""Generates subtitle files for audio/video files."""

    type: str
    r"""Defines the type of input.

    """
    url: str
    r"""The direct URL of the subtitle file."""
    language_name: str
    r"""Name of the language in which the subtitles will be generated."""
    language_code: LanguageCode
    r"""Language code for content localization"""


class SubtitleInput(BaseModel):
    r"""Generates subtitle files for audio/video files."""

    type: str
    r"""Defines the type of input.

    """

    url: str
    r"""The direct URL of the subtitle file."""

    language_name: Annotated[str, pydantic.Field(alias="languageName")]
    r"""Name of the language in which the subtitles will be generated."""

    language_code: Annotated[LanguageCode, pydantic.Field(alias="languageCode")]
    r"""Language code for content localization"""
