"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


TopErrorDetailsPercentageTypedDict = TypeAliasType(
    "TopErrorDetailsPercentageTypedDict", Union[int, float]
)
r"""views affected by the specific errors."""


TopErrorDetailsPercentage = TypeAliasType(
    "TopErrorDetailsPercentage", Union[int, float]
)
r"""views affected by the specific errors."""


UniqueViewersEffectedPercentageTypedDict = TypeAliasType(
    "UniqueViewersEffectedPercentageTypedDict", Union[int, float]
)
r"""percentage of unique viewers affected by the specific error."""


UniqueViewersEffectedPercentage = TypeAliasType(
    "UniqueViewersEffectedPercentage", Union[int, float]
)
r"""percentage of unique viewers affected by the specific error."""


class TopErrorDetailsTypedDict(TypedDict):
    percentage: NotRequired[Nullable[TopErrorDetailsPercentageTypedDict]]
    r"""views affected by the specific errors."""
    unique_viewers_effected_percentage: NotRequired[
        Nullable[UniqueViewersEffectedPercentageTypedDict]
    ]
    r"""percentage of unique viewers affected by the specific error."""
    notes: NotRequired[Nullable[str]]
    r"""Information about the specific error."""
    message: NotRequired[Nullable[str]]
    r"""error message or description."""
    last_seen: NotRequired[Nullable[str]]
    r"""The timestamp of when the error was last observed."""
    id: NotRequired[Nullable[str]]
    r"""unique identifier for the specific error."""
    description: NotRequired[Nullable[str]]
    r"""description of the specific error."""
    count: NotRequired[Nullable[int]]
    r"""Number of occurrences of the specific error."""
    code: NotRequired[Nullable[str]]
    r"""Error code associated with the specific error."""


class TopErrorDetails(BaseModel):
    percentage: OptionalNullable[TopErrorDetailsPercentage] = UNSET
    r"""views affected by the specific errors."""

    unique_viewers_effected_percentage: Annotated[
        OptionalNullable[UniqueViewersEffectedPercentage],
        pydantic.Field(alias="uniqueViewersEffectedPercentage"),
    ] = UNSET
    r"""percentage of unique viewers affected by the specific error."""

    notes: OptionalNullable[str] = UNSET
    r"""Information about the specific error."""

    message: OptionalNullable[str] = UNSET
    r"""error message or description."""

    last_seen: Annotated[OptionalNullable[str], pydantic.Field(alias="lastSeen")] = (
        UNSET
    )
    r"""The timestamp of when the error was last observed."""

    id: OptionalNullable[str] = UNSET
    r"""unique identifier for the specific error."""

    description: OptionalNullable[str] = UNSET
    r"""description of the specific error."""

    count: OptionalNullable[int] = UNSET
    r"""Number of occurrences of the specific error."""

    code: OptionalNullable[str] = UNSET
    r"""Error code associated with the specific error."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "percentage",
            "uniqueViewersEffectedPercentage",
            "notes",
            "message",
            "lastSeen",
            "id",
            "description",
            "count",
            "code",
        ]
        nullable_fields = [
            "percentage",
            "uniqueViewersEffectedPercentage",
            "notes",
            "message",
            "lastSeen",
            "id",
            "description",
            "count",
            "code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
