"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TrackTypedDict(TypedDict):
    r"""A media consists of different media tracks, like video, audio, and subtitle, all combined."""

    type: str
    r"""Defines the type of input. This option is mandatory."""
    id: NotRequired[str]
    r"""FastPix generates a unique identifier for each track."""
    width: NotRequired[float]
    r"""Track width denotes the range of widths applicable to a specific track. Currently, this setting can be modified only for video tracks"""
    height: NotRequired[float]
    r"""Track height denotes the range of height applicable to a specific track. Currently, this setting can be modified only for video tracks."""
    frame_rate: NotRequired[str]
    r"""Frame rate quantifies the speed at which frames are displayed per second. It represents the range of frames available for a specific track. If the frame rate of the input file is indeterminable, it will be indicated by a value of -1."""
    closed_captions: NotRequired[bool]
    r"""Indicates if the track contains closed captions."""


class Track(BaseModel):
    r"""A media consists of different media tracks, like video, audio, and subtitle, all combined."""

    type: str
    r"""Defines the type of input. This option is mandatory."""

    id: Optional[str] = None
    r"""FastPix generates a unique identifier for each track."""

    width: Optional[float] = None
    r"""Track width denotes the range of widths applicable to a specific track. Currently, this setting can be modified only for video tracks"""

    height: Optional[float] = None
    r"""Track height denotes the range of height applicable to a specific track. Currently, this setting can be modified only for video tracks."""

    frame_rate: Annotated[Optional[str], pydantic.Field(alias="frameRate")] = None
    r"""Frame rate quantifies the speed at which frames are displayed per second. It represents the range of frames available for a specific track. If the frame rate of the input file is indeterminable, it will be indicated by a value of -1."""

    closed_captions: Annotated[
        Optional[bool], pydantic.Field(alias="closedCaptions")
    ] = None
    r"""Indicates if the track contains closed captions."""
