"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .languagecode import LanguageCode
from ..types import BaseModel
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TrackSubtitlesGenerateRequestTypedDict(TypedDict):
    r"""Contains details for generating subtitle tracks for a media file."""

    language_name: str
    r"""The full name of the language in which subtitles will be generated."""
    language_code: LanguageCode
    r"""Language code for content localization"""
    metadata: NotRequired[Dict[str, str]]
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""


class TrackSubtitlesGenerateRequest(BaseModel):
    r"""Contains details for generating subtitle tracks for a media file."""

    language_name: Annotated[str, pydantic.Field(alias="languageName")]
    r"""The full name of the language in which subtitles will be generated."""

    language_code: Annotated[LanguageCode, pydantic.Field(alias="languageCode")]
    r"""Language code for content localization"""

    metadata: Optional[Dict[str, str]] = None
    r"""You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\" : \"value\" pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed."""
