"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .chaptersresponse import ChaptersResponse, ChaptersResponseTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateMediaChaptersRequestBodyTypedDict(TypedDict):
    chapters: bool
    r"""Enable or disable the chapters feature for the media. Set to `true` to enable chapters or `false` to disable.

    """


class UpdateMediaChaptersRequestBody(BaseModel):
    chapters: bool
    r"""Enable or disable the chapters feature for the media. Set to `true` to enable chapters or `false` to disable.

    """


class UpdateMediaChaptersRequestTypedDict(TypedDict):
    media_id: str
    r"""The unique identifier assigned to the media when created. The value should be a valid UUID.

    """
    request_body: UpdateMediaChaptersRequestBodyTypedDict


class UpdateMediaChaptersRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The unique identifier assigned to the media when created. The value should be a valid UUID.

    """

    request_body: Annotated[
        UpdateMediaChaptersRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdateMediaChaptersResponseTypedDict(TypedDict):
    r"""Media details updated successfully with the chapters feature enabled or disabled"""

    success: NotRequired[bool]
    r"""Indicates if the request was successful or not."""
    data: NotRequired[ChaptersResponseTypedDict]


class UpdateMediaChaptersResponse(BaseModel):
    r"""Media details updated successfully with the chapters feature enabled or disabled"""

    success: Optional[bool] = None
    r"""Indicates if the request was successful or not."""

    data: Optional[ChaptersResponse] = None
