"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .mediatype import MediaType
from .moderationresponse import ModerationResponse, ModerationResponseTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateMediaModerationModerationTypedDict(TypedDict):
    type: NotRequired[MediaType]
    r"""Type of media content"""


class UpdateMediaModerationModeration(BaseModel):
    type: Optional[MediaType] = None
    r"""Type of media content"""


class UpdateMediaModerationRequestBodyTypedDict(TypedDict):
    moderation: NotRequired[UpdateMediaModerationModerationTypedDict]


class UpdateMediaModerationRequestBody(BaseModel):
    moderation: Optional[UpdateMediaModerationModeration] = None


class UpdateMediaModerationRequestTypedDict(TypedDict):
    media_id: str
    r"""The unique identifier assigned to the media when created. The value should be a valid UUID.

    """
    request_body: UpdateMediaModerationRequestBodyTypedDict


class UpdateMediaModerationRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The unique identifier assigned to the media when created. The value should be a valid UUID.

    """

    request_body: Annotated[
        UpdateMediaModerationRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdateMediaModerationResponseTypedDict(TypedDict):
    r"""Media details updated successfully with the named entity extraction feature enabled or disabled"""

    success: NotRequired[bool]
    r"""Indicates if the request was successful or not."""
    data: NotRequired[ModerationResponseTypedDict]


class UpdateMediaModerationResponse(BaseModel):
    r"""Media details updated successfully with the named entity extraction feature enabled or disabled"""

    success: Optional[bool] = None
    r"""Indicates if the request was successful or not."""

    data: Optional[ModerationResponse] = None
