"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .namedentitiesresponse import NamedEntitiesResponse, NamedEntitiesResponseTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateMediaNamedEntitiesRequestBodyTypedDict(TypedDict):
    named_entities: bool
    r"""Enable or disable named entity extraction. Set to `true` to enable or `false` to disable.

    """


class UpdateMediaNamedEntitiesRequestBody(BaseModel):
    named_entities: Annotated[bool, pydantic.Field(alias="namedEntities")]
    r"""Enable or disable named entity extraction. Set to `true` to enable or `false` to disable.

    """


class UpdateMediaNamedEntitiesRequestTypedDict(TypedDict):
    media_id: str
    r"""The unique identifier assigned to the media when created. The value should be a valid UUID.

    """
    request_body: UpdateMediaNamedEntitiesRequestBodyTypedDict


class UpdateMediaNamedEntitiesRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The unique identifier assigned to the media when created. The value should be a valid UUID.

    """

    request_body: Annotated[
        UpdateMediaNamedEntitiesRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdateMediaNamedEntitiesResponseTypedDict(TypedDict):
    r"""Media details updated successfully with the named entity extraction feature enabled or disabled"""

    success: NotRequired[bool]
    r"""Indicates if the request was successful or not."""
    data: NotRequired[NamedEntitiesResponseTypedDict]


class UpdateMediaNamedEntitiesResponse(BaseModel):
    r"""Media details updated successfully with the named entity extraction feature enabled or disabled"""

    success: Optional[bool] = None
    r"""Indicates if the request was successful or not."""

    data: Optional[NamedEntitiesResponse] = None
