"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .summaryresponse import SummaryResponse, SummaryResponseTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateMediaSummaryRequestBodyTypedDict(TypedDict):
    generate: bool
    r"""Enable or disable the summary feature for the media. Set to true to enable summary or false to disable.

    """
    summary_length: NotRequired[int]
    r"""Specifies the desired word count for the generated summary.
    - The value must be between **30** and **250** words.

    """


class UpdateMediaSummaryRequestBody(BaseModel):
    generate: bool
    r"""Enable or disable the summary feature for the media. Set to true to enable summary or false to disable.

    """

    summary_length: Annotated[Optional[int], pydantic.Field(alias="summaryLength")] = (
        100
    )
    r"""Specifies the desired word count for the generated summary.
    - The value must be between **30** and **250** words.

    """


class UpdateMediaSummaryRequestTypedDict(TypedDict):
    media_id: str
    r"""The unique identifier assigned to the media when created. The value should be a valid UUID.

    """
    request_body: UpdateMediaSummaryRequestBodyTypedDict


class UpdateMediaSummaryRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The unique identifier assigned to the media when created. The value should be a valid UUID.

    """

    request_body: Annotated[
        UpdateMediaSummaryRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdateMediaSummaryResponseTypedDict(TypedDict):
    r"""Media details updated successfully with the generated summary"""

    success: NotRequired[bool]
    r"""Indicates if the request was successful or not."""
    data: NotRequired[SummaryResponseTypedDict]


class UpdateMediaSummaryResponse(BaseModel):
    r"""Media details updated successfully with the generated summary"""

    success: Optional[bool] = None
    r"""Indicates if the request was successful or not."""

    data: Optional[SummaryResponse] = None
