"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .updatetrackrequest import UpdateTrackRequest, UpdateTrackRequestTypedDict
from .updatetrackresponse import UpdateTrackResponse, UpdateTrackResponseTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateMediaTrackRequestTypedDict(TypedDict):
    track_id: str
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""
    media_id: str
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""
    update_track_request: UpdateTrackRequestTypedDict


class UpdateMediaTrackRequest(BaseModel):
    track_id: Annotated[
        str,
        pydantic.Field(alias="trackId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""

    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""

    update_track_request: Annotated[
        UpdateTrackRequest,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdateMediaTrackResponseTypedDict(TypedDict):
    r"""Media details updated successfully"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[UpdateTrackResponseTypedDict]
    r"""Contains details about the track that was added or updated."""


class UpdateMediaTrackResponse(BaseModel):
    r"""Media details updated successfully"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[UpdateTrackResponse] = None
    r"""Contains details about the track that was added or updated."""
