"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .media import Media, MediaTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdatedMediaRequestBodyTypedDict(TypedDict):
    metadata: NotRequired[Dict[str, str]]


class UpdatedMediaRequestBody(BaseModel):
    metadata: Optional[Dict[str, str]] = None


class UpdatedMediaRequestTypedDict(TypedDict):
    media_id: str
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""
    request_body: UpdatedMediaRequestBodyTypedDict


class UpdatedMediaRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters."""

    request_body: Annotated[
        UpdatedMediaRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdatedMediaResponseTypedDict(TypedDict):
    r"""Media details updated successfully"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[MediaTypedDict]


class UpdatedMediaResponse(BaseModel):
    r"""Media details updated successfully"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[Media] = None
