"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .media import Media, MediaTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


UpdatedMp4SupportMp4Support = Literal[
    "none",
    "capped_4k",
    "audioOnly",
    "audioOnly,capped_4k",
]
r"""Determines the type of MP4 support for the media.   - **none**: Disables MP4 support.   - **capped_4k**: Enables MP4 downloads with resolutions up to 4K.   - **audioOnly**: Provides an MP4 stream containing only the audio.   - **audioOnly,capped_4k**: Enables both MP4 video downloads (up to 4K) and an audio-only stream."""


class UpdatedMp4SupportRequestBodyTypedDict(TypedDict):
    mp4_support: NotRequired[UpdatedMp4SupportMp4Support]
    r"""Determines the type of MP4 support for the media.   - **none**: Disables MP4 support.   - **capped_4k**: Enables MP4 downloads with resolutions up to 4K.   - **audioOnly**: Provides an MP4 stream containing only the audio.   - **audioOnly,capped_4k**: Enables both MP4 video downloads (up to 4K) and an audio-only stream."""


class UpdatedMp4SupportRequestBody(BaseModel):
    mp4_support: Annotated[
        Optional[UpdatedMp4SupportMp4Support], pydantic.Field(alias="mp4Support")
    ] = None
    r"""Determines the type of MP4 support for the media.   - **none**: Disables MP4 support.   - **capped_4k**: Enables MP4 downloads with resolutions up to 4K.   - **audioOnly**: Provides an MP4 stream containing only the audio.   - **audioOnly,capped_4k**: Enables both MP4 video downloads (up to 4K) and an audio-only stream."""


class UpdatedMp4SupportRequestTypedDict(TypedDict):
    media_id: str
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.

    """
    request_body: UpdatedMp4SupportRequestBodyTypedDict


class UpdatedMp4SupportRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.

    """

    request_body: Annotated[
        UpdatedMp4SupportRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdatedMp4SupportResponseTypedDict(TypedDict):
    r"""Media details updated successfully"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[MediaTypedDict]


class UpdatedMp4SupportResponse(BaseModel):
    r"""Media details updated successfully"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[Media] = None
