"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from .media import Media, MediaTypedDict
from ..types import BaseModel
from ..utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdatedSourceAccessRequestBodyTypedDict(TypedDict):
    source_access: NotRequired[bool]
    r"""The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it."""


class UpdatedSourceAccessRequestBody(BaseModel):
    source_access: Annotated[Optional[bool], pydantic.Field(alias="sourceAccess")] = (
        None
    )
    r"""The sourceAccess parameter determines whether the original media file is accessible. Set to true to enable access or false to restrict it."""


class UpdatedSourceAccessRequestTypedDict(TypedDict):
    media_id: str
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.

    """
    request_body: UpdatedSourceAccessRequestBodyTypedDict


class UpdatedSourceAccessRequest(BaseModel):
    media_id: Annotated[
        str,
        pydantic.Field(alias="mediaId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""When creating the media, FastPix assigns a universally unique identifier with a maximum length of 255 characters.

    """

    request_body: Annotated[
        UpdatedSourceAccessRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdatedSourceAccessResponseTypedDict(TypedDict):
    r"""Media details updated successfully"""

    success: NotRequired[bool]
    r"""Demonstrates whether the request is successful or not."""
    data: NotRequired[MediaTypedDict]


class UpdatedSourceAccessResponse(BaseModel):
    r"""Media details updated successfully"""

    success: Optional[bool] = None
    r"""Demonstrates whether the request is successful or not."""

    data: Optional[Media] = None
