"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class Segment2TypedDict(TypedDict):
    url: str
    r"""URL of the segment to be added."""
    insert_at_end: bool
    r"""Flag indicating the segment should be inserted at the end."""


class Segment2(BaseModel):
    url: str
    r"""URL of the segment to be added."""

    insert_at_end: Annotated[bool, pydantic.Field(alias="insertAtEnd")]
    r"""Flag indicating the segment should be inserted at the end."""


class Segment1TypedDict(TypedDict):
    url: str
    r"""URL of the segment to be added."""
    insert_at: int
    r"""The timestamp at which the segment should be inserted."""


class Segment1(BaseModel):
    url: str
    r"""URL of the segment to be added."""

    insert_at: Annotated[int, pydantic.Field(alias="insertAt")]
    r"""The timestamp at which the segment should be inserted."""


SegmentUnionTypedDict = TypeAliasType(
    "SegmentUnionTypedDict", Union[Segment1TypedDict, Segment2TypedDict]
)


SegmentUnion = TypeAliasType("SegmentUnion", Union[Segment1, Segment2])


class VideoInputTypedDict(TypedDict):
    type: str
    r"""Defines the type of input.

    """
    url: str
    r"""The url hosts the media file for FastPix, which needs to be downloaded to use further. It supports formats like MP3, MP4, MOV, MKV, or TS, and includes text tracks for subtitles/CC (SRT file/VTT file). While FastPix can handle various audio and video formats and codecs, using standard inputs can help with optimal processing speed.

    """
    start_time: NotRequired[float]
    r"""Start time indicates where encoding should begin within the video file. For example, if you want to encode a segment from 3 minutes (180 seconds) to 6 minutes (360 seconds) in a 10-minute (600 seconds) video, the start time is 3 minutes (180 seconds). Note: Start time is always mentioned in seconds.

    """
    end_time: NotRequired[float]
    r"""End time indicates where encoding should end within the video file. For example, if you want to encode a segment from 3 minutes (180 seconds) to 6 minutes (360 seconds) in a 10-minute (600 seconds) video, the end time is 6 minutes (360 seconds). Note: End time is always mentioned in seconds.

    """
    intro_url: NotRequired[str]
    r"""The url of the intro video which is to be added at the start of the video.

    """
    outro_url: NotRequired[str]
    r"""The url of the outro video which is to be added at the end of the video.

    """
    expunge_segments: NotRequired[List[str]]
    r"""The list of the startTime-endTime of the segments to be removed from the actual video.

    """
    segments: NotRequired[List[SegmentUnionTypedDict]]
    r"""A list of media segments to be added or processed. Each segment includes details such as the URL of the media file and instructions on where it should be inserted in the final media composition. A segment can either specify an exact timestamp  (`insertAt`) or indicate that it should be added at the end (`insertAtEnd`)."""


class VideoInput(BaseModel):
    type: str
    r"""Defines the type of input.

    """

    url: str
    r"""The url hosts the media file for FastPix, which needs to be downloaded to use further. It supports formats like MP3, MP4, MOV, MKV, or TS, and includes text tracks for subtitles/CC (SRT file/VTT file). While FastPix can handle various audio and video formats and codecs, using standard inputs can help with optimal processing speed.

    """

    start_time: Annotated[Optional[float], pydantic.Field(alias="startTime")] = None
    r"""Start time indicates where encoding should begin within the video file. For example, if you want to encode a segment from 3 minutes (180 seconds) to 6 minutes (360 seconds) in a 10-minute (600 seconds) video, the start time is 3 minutes (180 seconds). Note: Start time is always mentioned in seconds.

    """

    end_time: Annotated[Optional[float], pydantic.Field(alias="endTime")] = None
    r"""End time indicates where encoding should end within the video file. For example, if you want to encode a segment from 3 minutes (180 seconds) to 6 minutes (360 seconds) in a 10-minute (600 seconds) video, the end time is 6 minutes (360 seconds). Note: End time is always mentioned in seconds.

    """

    intro_url: Annotated[Optional[str], pydantic.Field(alias="introUrl")] = None
    r"""The url of the intro video which is to be added at the start of the video.

    """

    outro_url: Annotated[Optional[str], pydantic.Field(alias="outroUrl")] = None
    r"""The url of the outro video which is to be added at the end of the video.

    """

    expunge_segments: Annotated[
        Optional[List[str]], pydantic.Field(alias="expungeSegments")
    ] = None
    r"""The list of the startTime-endTime of the segments to be removed from the actual video.

    """

    segments: Optional[List[SegmentUnion]] = None
    r"""A list of media segments to be added or processed. Each segment includes details such as the URL of the media file and instructions on where it should be inserted in the final media composition. A segment can either specify an exact timestamp  (`insertAt`) or indicate that it should be added at the end (`insertAtEnd`)."""
