"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


EventTimeTypedDict = TypeAliasType("EventTimeTypedDict", Union[str, int])
r"""The unix epoch timestamp when the event was captured.

"""


EventTime = TypeAliasType("EventTime", Union[str, int])
r"""The unix epoch timestamp when the event was captured.

"""


class DetailsTypedDict(TypedDict):
    player_source_bitrate: NotRequired[Nullable[int]]
    r"""The player_source_bitrate represents the bitrate of the video stream that is being played, measured in bits per second (bps). This value indicates the quality of the video being streamed, with higher bitrates typically corresponding to better video quality but requiring more bandwidth.

    """
    player_source_codec: NotRequired[Nullable[str]]
    r"""The player_source_codec represents the video or audio codec being used to decode and play the media. A codec is a technology used to compress and decompress digital media files, enabling efficient transmission and storage while maintaining quality.

    """
    player_source_height: NotRequired[Nullable[int]]
    r"""The player_source_height refers to the vertical resolution of the video being played, measured in pixels. This value represents the height dimension of the video frame and is part of the overall resolution of the video (e.g., 1920x1080, where the height is 1080 pixels).

    """
    player_source_width: NotRequired[Nullable[int]]
    r"""The player_source_width refers to the horizontal resolution of the video being played, measured in pixels. This value represents the width dimension of the video frame and is part of the overall video resolution (e.g., 1920x1080, where the width is 1920 pixels).

    """


class Details(BaseModel):
    player_source_bitrate: OptionalNullable[int] = UNSET
    r"""The player_source_bitrate represents the bitrate of the video stream that is being played, measured in bits per second (bps). This value indicates the quality of the video being streamed, with higher bitrates typically corresponding to better video quality but requiring more bandwidth.

    """

    player_source_codec: OptionalNullable[str] = UNSET
    r"""The player_source_codec represents the video or audio codec being used to decode and play the media. A codec is a technology used to compress and decompress digital media files, enabling efficient transmission and storage while maintaining quality.

    """

    player_source_height: Annotated[
        OptionalNullable[int], pydantic.Field(alias="playerSourceHeight")
    ] = UNSET
    r"""The player_source_height refers to the vertical resolution of the video being played, measured in pixels. This value represents the height dimension of the video frame and is part of the overall resolution of the video (e.g., 1920x1080, where the height is 1080 pixels).

    """

    player_source_width: Annotated[
        OptionalNullable[int], pydantic.Field(alias="playerSourceWidth")
    ] = UNSET
    r"""The player_source_width refers to the horizontal resolution of the video being played, measured in pixels. This value represents the width dimension of the video frame and is part of the overall video resolution (e.g., 1920x1080, where the width is 1920 pixels).

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "player_source_bitrate",
            "player_source_codec",
            "playerSourceHeight",
            "playerSourceWidth",
        ]
        nullable_fields = [
            "player_source_bitrate",
            "player_source_codec",
            "playerSourceHeight",
            "playerSourceWidth",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EventTypedDict(TypedDict):
    event_name: NotRequired[Nullable[str]]
    r"""Name of the event.

    """
    event_time: NotRequired[Nullable[EventTimeTypedDict]]
    r"""The unix epoch timestamp when the event was captured.

    """
    viewer_time: NotRequired[Nullable[int]]
    r"""The unix epoch timestamp which represents the actual time the event has occured.

    """
    player_playhead_time: NotRequired[Nullable[int]]
    r"""The player_playhead_time represents the current position of the playhead (the point in the video that is being watched) on the video seekbar, measured in milliseconds. This value indicates how far into the video playback has progressed at any given moment.

    """
    details: NotRequired[DetailsTypedDict]


class Event(BaseModel):
    event_name: OptionalNullable[str] = UNSET
    r"""Name of the event.

    """

    event_time: OptionalNullable[EventTime] = UNSET
    r"""The unix epoch timestamp when the event was captured.

    """

    viewer_time: OptionalNullable[int] = UNSET
    r"""The unix epoch timestamp which represents the actual time the event has occured.

    """

    player_playhead_time: OptionalNullable[int] = UNSET
    r"""The player_playhead_time represents the current position of the playhead (the point in the video that is being watched) on the video seekbar, measured in milliseconds. This value indicates how far into the video playback has progressed at any given moment.

    """

    details: Optional[Details] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "event_name",
            "event_time",
            "viewer_time",
            "player_playhead_time",
            "details",
        ]
        nullable_fields = [
            "event_name",
            "event_time",
            "viewer_time",
            "player_playhead_time",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PlayerHeightTypedDict = TypeAliasType("PlayerHeightTypedDict", Union[str, float])
r"""Player Height refers to the vertical dimension, measured in pixels, of the video player as it appears on the webpage.

"""


PlayerHeight = TypeAliasType("PlayerHeight", Union[str, float])
r"""Player Height refers to the vertical dimension, measured in pixels, of the video player as it appears on the webpage.

"""


PlayerWidthTypedDict = TypeAliasType("PlayerWidthTypedDict", Union[str, float])
r"""Player Width refers to the width of the player displayed within the webpage, measured in pixels.

"""


PlayerWidth = TypeAliasType("PlayerWidth", Union[str, float])
r"""Player Width refers to the width of the player displayed within the webpage, measured in pixels.

"""


class ViewsTypedDict(TypedDict):
    r"""Displays the result of the request."""

    asn_name: NotRequired[Nullable[str]]
    r"""The Name associated with the asnId.

    """
    asn_id: NotRequired[Nullable[int]]
    r"""The unique identifier assigned to an Autonomous System (AS) on the Internet. The ASN is used to identify and exchange routing information between different networks.

    """
    media_id: NotRequired[Nullable[str]]
    r"""The media Id value if the video asset is internal to FastPix.

    """
    buffer_count: NotRequired[Nullable[int]]
    r"""Buffer Count represents the number of rebuffering events occurring during the video view.

    """
    buffer_fill: NotRequired[Nullable[int]]
    r"""Buffer Fill indicates the total time, in milliseconds, that viewers wait for rebuffering per video view.

    """
    buffer_frequency: NotRequired[Nullable[float]]
    r"""Buffer Frequency measures the rate at which rebuffering events occur, expressed as events per millisecond.

    """
    cdn: NotRequired[Nullable[str]]
    r"""Content Delivery Network (CDN) refers to the network infrastructure responsible for delivering the video content to the viewer.

    """
    city: NotRequired[Nullable[str]]
    r"""City indicates the geographical location of the viewer accessing the video content.

    """
    continent: NotRequired[Nullable[str]]
    r"""Continent represents the continent name of the viewer accessing the video content.

    """
    country_code: NotRequired[Nullable[str]]
    r"""Country Code denotes the two-letter ISO code representing the country of origin for the viewer accessing the video content.

    """
    country: NotRequired[Nullable[str]]
    r"""Country represents the coded text that represents the country name of viewer accessing the video content.

    """
    custom1: NotRequired[Nullable[str]]
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """
    custom2: NotRequired[Nullable[str]]
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """
    custom3: NotRequired[Nullable[str]]
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """
    custom4: NotRequired[Nullable[str]]
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """
    custom5: NotRequired[Nullable[str]]
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """
    custom6: NotRequired[Nullable[str]]
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """
    custom7: NotRequired[Nullable[str]]
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """
    custom8: NotRequired[Nullable[str]]
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """
    custom9: NotRequired[Nullable[str]]
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """
    custom10: NotRequired[Nullable[str]]
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """
    workspace_id: NotRequired[str]
    r"""It is a unique identifier associated with a specific workspace within the FastPix platform.

    """
    events: NotRequired[List[EventTypedDict]]
    r"""Events specifies the order of events journey of the video playback

    """
    exit_before_video_start: NotRequired[bool]
    r"""Exit Before Video Start indicates whether a viewer abandoned the video before it started playing, typically due to long loading times.

    """
    experiment_name: NotRequired[str]
    r"""Experiment Name is used in A/B testing scenarios to categorize video views into different experiments.

    """
    insert_timestamp: NotRequired[str]
    r"""Insert Timestamp refers to the time instance when the view is started.

    """
    latitude: NotRequired[Nullable[str]]
    r"""Latitude refers to the geographical coordinate representing the north-south position of the viewer's location, truncated to one decimal place.

    """
    fp_live_stream_id: NotRequired[Nullable[str]]
    r"""FastPix Live Stream ID is the unique identifier associated with a live stream video media within the FastPix Video platform.

    """
    live_stream_latency: NotRequired[Nullable[float]]
    r"""Live Stream Latency measures the average time taken from the point of ingest to the point of display for live stream video views.

    """
    longitude: NotRequired[Nullable[str]]
    r"""Longitude denotes the geographical coordinate representing the east-west position of the viewer's location, truncated to one decimal place.

    """
    page_load_time: NotRequired[Nullable[int]]
    r"""Page Load Time measures the time from when the user initiates loading the page to when all resources are loaded on the page.

    """
    page_context: NotRequired[Nullable[str]]
    r"""Page Context provides contextual information about the type of page being accessed.

    """
    view_page_url: NotRequired[Nullable[str]]
    r"""View Page URL denotes the URL address of the web page where the video content is being accessed.

    """
    fp_playback_id: NotRequired[Nullable[str]]
    r"""FastPix Playback ID refers to the unique identifier associated with the playback instance of a video, particularly used in FastPix Video platform.

    """
    playback_score: NotRequired[Nullable[float]]
    r"""Playback Success Score represents a numerical value indicating the success or quality of the video playback experience.

    """
    player_autoplay_on: NotRequired[bool]
    r"""Player Autoplay On indicates whether the video player automatically initiated playback of the video content.

    """
    error_code: NotRequired[Nullable[str]]
    r"""Error Code is an identifier representing a specific type of error that occurred during video playback, potentially leading to playback failure.

    """
    error_message: NotRequired[Nullable[str]]
    r"""Error Message is a descriptive message generated by the video player when an error occurs during playback, associated with an error code.

    """
    player_height: NotRequired[Nullable[PlayerHeightTypedDict]]
    r"""Player Height refers to the vertical dimension, measured in pixels, of the video player as it appears on the webpage.

    """
    player_instance_id: NotRequired[Nullable[str]]
    r"""Player Instance ID is a unique identifier that distinguishes each instance of the Player class created when initializing a video.

    """
    player_language: NotRequired[Nullable[str]]
    r"""Player Language indicates the language used for text elements within the video player interface.

    """
    fp_sdk: NotRequired[Nullable[str]]
    r"""FastPix SDK Name identifies the name of the FastPix Player SDK utilized within the player workspace.

    """
    fp_sdk_version: NotRequired[Nullable[str]]
    r"""FastPix SDK Version specifies the version of the FastPix Player SDK integrated into the player.

    """
    player_name: NotRequired[Nullable[str]]
    r"""Player Name serves to differentiate various configurations or types of players used across the website or application.

    """
    player_poster: NotRequired[Nullable[str]]
    r"""Player Poster refers to the image displayed as a preview before the video playback begins.

    """
    player_preload_on: NotRequired[bool]
    r"""Player Preload On indicates whether the player is configured to preload the video content upon page load.

    """
    player_remote_played: NotRequired[bool]
    r"""Player Remote Played specifies if the video is being remotely played to devices such as AirPlay or Chromecast, obtained from the SDK.

    """
    player_software_version: NotRequired[Nullable[str]]
    r"""Player Software Version indicates the version number of the player software installed.

    """
    player_software_name: NotRequired[Nullable[str]]
    r"""Player Software Name denotes the software utilized for video playback within the player workspace.

    """
    video_source_domain: NotRequired[Nullable[str]]
    r"""Video Source Domain identifies the domain from which the video source originates.

    """
    video_source_duration: NotRequired[Nullable[int]]
    r"""Video Source Duration represents the duration of the video source content, measured in milliseconds.

    """
    player_source_height: NotRequired[Nullable[int]]
    r"""Player Source Height denotes the vertical dimension, measured in pixels, of the source video content being transmitted to the player.

    """
    video_source_hostname: NotRequired[Nullable[str]]
    r"""Video Source Hostname represents the hostname of the video

    """
    video_source_stream_type: NotRequired[Nullable[str]]
    r"""Video Source Stream Type denotes the type of stream used by the player, although it is currently unused.

    """
    video_source_type: NotRequired[Nullable[str]]
    r"""Video Source Type denotes the format of the video source as determined by the player, including formats

    """
    video_source_url: NotRequired[Nullable[str]]
    r"""Player Source URL refers to the URL of the video source accessed by the player.

    """
    player_source_width: NotRequired[Nullable[int]]
    r"""Source Width represents the width of the source video as perceived by the player, typically measured in pixels.

    """
    player_initialization_time: NotRequired[Nullable[int]]
    r"""Player Initialisation Time measures the duration, in milliseconds, from the initialization of the player within the webpage to its readiness to receive further instructions.

    """
    player_version: NotRequired[Nullable[str]]
    r"""Player Version indicates the version of the player used to render the video content. It is often utilized for performance comparison between different player versions.

    """
    player_width: NotRequired[Nullable[PlayerWidthTypedDict]]
    r"""Player Width refers to the width of the player displayed within the webpage, measured in pixels.

    """
    render_quality_score: NotRequired[Nullable[float]]
    r"""Render Quality Score is a decimal value representing the score indicating the perceived quality of the video.

    """
    buffer_ratio: NotRequired[Nullable[float]]
    r"""Buffer Ratio refers to the percentage of time during video playback where the viewer experiences buffering or rebuffering events.

    """
    stability_score: NotRequired[Nullable[float]]
    r"""Stability Score quantifies the smoothness of video playback, typically represented as a decimal value.

    """
    region: NotRequired[Nullable[str]]
    r"""Region denotes the geographical region of the viewer accessing the video content.

    """
    session_id: NotRequired[Nullable[str]]
    r"""Session ID refers to the unique identifier tracking a viewer's session within the FastPix platform.

    """
    startup_score: NotRequired[Nullable[float]]
    r"""Startup Time Score evaluates the startup performance of the player, usually represented as a decimal value

    """
    sub_property_id: NotRequired[Nullable[str]]
    r"""Sub Property ID denotes the unique identifier assigned to FastPix properties, previously linked with a specific workspace.

    """
    video_startup_time: NotRequired[Nullable[int]]
    r"""Video Startup Time measures the duration, in milliseconds, from the initialization of the player within the webpage to its readiness to receive further instructions.

    """
    updated_timestamp: NotRequired[Nullable[str]]
    r"""Updated Timestamp refers to when the record is updated to a particular Video.

    """
    used_full_screen: NotRequired[bool]
    r"""Used Fullscreen denotes whether the viewer utilized the full-screen mode while watching the video.

    """
    video_content_type: NotRequired[Nullable[str]]
    r"""Video Content Type specifies the classification of the video content.

    """
    video_duration: NotRequired[Nullable[int]]
    r"""Video Duration represents the length of the video, provided in milliseconds, typically supplied to FastPix via custom metadata.

    """
    video_id: NotRequired[Nullable[str]]
    r"""Video ID refers to an internal identifier assigned by the user or system to uniquely identify a particular video.

    """
    video_language: NotRequired[Nullable[str]]
    r"""Video Language denotes the primary audio language of the video content, assuming it remains unchanged after playback initiation.

    """
    video_series: NotRequired[Nullable[str]]
    r"""Video Series denotes the name of a series to which the video content belongs.

    """
    video_startup_failed: NotRequired[bool]
    r"""Video Startup Failure is a boolean metric indicating whether a viewer encountered an error before the first frame of the video commenced playback.

    """
    video_title: NotRequired[Nullable[str]]
    r"""Video Title refers to the title of the video content being viewed.

    """
    avg_request_latency: NotRequired[Nullable[float]]
    r"""Average Request Latency average time it takes for a request to be made and processed during video playback

    """
    avg_request_throughput: NotRequired[Nullable[float]]
    r"""Average Request Throughput refers to the average throughput or data transfer rate of HTTP requests made during video playback

    """
    drm_type: NotRequired[Nullable[str]]
    r"""DRM Type indicates the type of Digital Rights Management (DRM) utilized during video playback

    """
    dropped_frame_count: NotRequired[Nullable[int]]
    r"""Dropped Frame Count represents the number of frames dropped by the video player during playback.

    """
    view_end: NotRequired[Nullable[str]]
    r"""View End refers to the date and time, in Coordinated Universal Time (UTC), when the video viewing session concluded.

    """
    view_has_ad: NotRequired[bool]
    r"""View Has Ad is a boolean metric indicating whether an advertisement played or attempted to play during the video view.

    """
    view_id: NotRequired[str]
    r"""View ID is a unique identifier assigned to each individual video viewing session.

    """
    max_downscaling: NotRequired[Nullable[float]]
    r"""Maximum Downscale Percentage represents the highest percentage of downscaling applied to the video during the view.

    """
    view_max_playhead_position: NotRequired[Nullable[int]]
    r"""View Max Playhead Position represents the furthest point reached by the playhead during the video view, measured in milliseconds.

    """
    max_request_latency: NotRequired[Nullable[float]]
    r"""Max request Latency refers to the maximum rate of data transfer (throughput) during requests made by the playback.

    """
    max_upscaling: NotRequired[Nullable[float]]
    r"""Maximum Upscale Percentage represents the highest percentage of upscaling applied to the video during the view.

    """
    view_playing_time: NotRequired[Nullable[int]]
    r"""Playing Time denotes the total duration of time the video content was actively playing during the view, excluding time spent buffering, seeking, or joining.

    """
    view_seeked_count: NotRequired[Nullable[int]]
    r"""View Seeked Count signifies the number of times the viewer attempted to seek to a new location within the video.

    """
    view_seeked_duration: NotRequired[Nullable[int]]
    r"""View Seeked Duration indicates the total duration of time spent waiting for playback to resume after the viewer seeks to a new location. Seek Latency metric in the Dashboard is derived by dividing this value by the view_seek_count.

    """
    view_start: NotRequired[Nullable[str]]
    r"""View Start refers to the date and time, in Coordinated Universal Time (UTC), when the video viewing session commenced.

    """
    view_total_content_playback_time: NotRequired[Nullable[int]]
    r"""View Total content Playback Time represents the cumulative duration of video content watched by the viewer, measured in milliseconds. This metric is internally utilized to calculate upscale and downscale percentages.

    """
    avg_downscaling: NotRequired[Nullable[float]]
    r"""Average Downscaling refers to the average reduction in video resolution or quality during the playback of video content.

    """
    avg_upscaling: NotRequired[Nullable[float]]
    r"""Average Upscaling refers to the average resolution of the video source is lower than the resolution of the playback device or screen.

    """
    browser_name: NotRequired[Nullable[str]]
    r"""Browser denotes the software application utilized by the viewer to access and watch the video content

    """
    browser_version: NotRequired[Nullable[str]]
    r"""Browser version signifies the specific version of the browser software employed by the viewer

    """
    connectiontype: NotRequired[Nullable[str]]
    r"""Connection Type signifies the type of network connection utilized by the viewer's device

    """
    device_type: NotRequired[Nullable[str]]
    r"""Device Type denotes the classification of the device used by the viewer

    """
    device_manufacturer: NotRequired[Nullable[str]]
    r"""Device Manufacturer indicates the brand or manufacturer of the device used by the viewer.

    """
    device_model: NotRequired[Nullable[str]]
    r"""Device Model represents the specific model of the device used by the viewer.

    """
    device_name: NotRequired[Nullable[str]]
    r"""Device Name refers to the name or label assigned to the device used by the viewer.

    """
    quality_of_experience_score: NotRequired[Nullable[float]]
    r"""Quality Of Experience Score quantifies the overall viewer experience based on various metrics, providing a decimal score to assess the quality of the viewing experience.

    """
    os_name: NotRequired[Nullable[str]]
    r"""Operating System signifies the name of software platform utilized by the viewer.

    """
    os_version: NotRequired[str]
    r"""Operating System Version specifies the specific version of the operating system being used by the viewer

    """
    user_agent: NotRequired[Nullable[str]]
    r"""User Agent represents the user agent string transmitted by the viewer's device to identify itself to the server, typically including information about the device and browser.

    """
    viewer_id: NotRequired[Nullable[str]]
    r"""Viewer ID refers to a customer-defined identifier representing the viewer who is watching the video stream. It should be anonymized and not contain any personally identifiable information.

    """
    total_watch_time: NotRequired[Nullable[int]]
    r"""Total Watch Time denotes the total duration of video content watched by the viewer, encompassing startup time, playing time, and potential rebuffering time, measured in milliseconds.

    """
    average_bitrate: NotRequired[Nullable[float]]
    r"""Average Bitrate represents the average bitrate of the video content watched by the viewer, expressed in bits per second (bps). This metric provides insight into the quality of the video stream.

    """
    jump_latency: NotRequired[Nullable[float]]
    r"""Jump Latency refers to the delay or latency experienced when there is a jump or seek action performed by the viewer while watching a video.

    """
    player_resolution: NotRequired[Nullable[str]]
    r"""Player Resolution refers to the resolution of the video player window or viewport where the video content is being displayed.

    """
    video_resolution: NotRequired[Nullable[str]]
    r"""videoResolution refers to the resolution of the video being played.

    """


class Views(BaseModel):
    r"""Displays the result of the request."""

    asn_name: Annotated[OptionalNullable[str], pydantic.Field(alias="asnName")] = UNSET
    r"""The Name associated with the asnId.

    """

    asn_id: Annotated[OptionalNullable[int], pydantic.Field(alias="asnId")] = UNSET
    r"""The unique identifier assigned to an Autonomous System (AS) on the Internet. The ASN is used to identify and exchange routing information between different networks.

    """

    media_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mediaId")] = UNSET
    r"""The media Id value if the video asset is internal to FastPix.

    """

    buffer_count: Annotated[
        OptionalNullable[int], pydantic.Field(alias="bufferCount")
    ] = UNSET
    r"""Buffer Count represents the number of rebuffering events occurring during the video view.

    """

    buffer_fill: Annotated[
        OptionalNullable[int], pydantic.Field(alias="bufferFill")
    ] = UNSET
    r"""Buffer Fill indicates the total time, in milliseconds, that viewers wait for rebuffering per video view.

    """

    buffer_frequency: Annotated[
        OptionalNullable[float], pydantic.Field(alias="BufferFrequency")
    ] = UNSET
    r"""Buffer Frequency measures the rate at which rebuffering events occur, expressed as events per millisecond.

    """

    cdn: OptionalNullable[str] = UNSET
    r"""Content Delivery Network (CDN) refers to the network infrastructure responsible for delivering the video content to the viewer.

    """

    city: OptionalNullable[str] = UNSET
    r"""City indicates the geographical location of the viewer accessing the video content.

    """

    continent: OptionalNullable[str] = UNSET
    r"""Continent represents the continent name of the viewer accessing the video content.

    """

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""Country Code denotes the two-letter ISO code representing the country of origin for the viewer accessing the video content.

    """

    country: OptionalNullable[str] = UNSET
    r"""Country represents the coded text that represents the country name of viewer accessing the video content.

    """

    custom1: OptionalNullable[str] = UNSET
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """

    custom2: OptionalNullable[str] = UNSET
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """

    custom3: OptionalNullable[str] = UNSET
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """

    custom4: OptionalNullable[str] = UNSET
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """

    custom5: OptionalNullable[str] = UNSET
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """

    custom6: OptionalNullable[str] = UNSET
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """

    custom7: OptionalNullable[str] = UNSET
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """

    custom8: OptionalNullable[str] = UNSET
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """

    custom9: OptionalNullable[str] = UNSET
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """

    custom10: OptionalNullable[str] = UNSET
    r"""User defined metadata. Only accessible once it is enabled in the organization settings.

    """

    workspace_id: Annotated[Optional[str], pydantic.Field(alias="workspaceId")] = None
    r"""It is a unique identifier associated with a specific workspace within the FastPix platform.

    """

    events: Optional[List[Event]] = None
    r"""Events specifies the order of events journey of the video playback

    """

    exit_before_video_start: Annotated[
        Optional[bool], pydantic.Field(alias="exitBeforeVideoStart")
    ] = None
    r"""Exit Before Video Start indicates whether a viewer abandoned the video before it started playing, typically due to long loading times.

    """

    experiment_name: Annotated[
        Optional[str], pydantic.Field(alias="experimentName")
    ] = None
    r"""Experiment Name is used in A/B testing scenarios to categorize video views into different experiments.

    """

    insert_timestamp: Annotated[
        Optional[str], pydantic.Field(alias="insertTimestamp")
    ] = None
    r"""Insert Timestamp refers to the time instance when the view is started.

    """

    latitude: OptionalNullable[str] = UNSET
    r"""Latitude refers to the geographical coordinate representing the north-south position of the viewer's location, truncated to one decimal place.

    """

    fp_live_stream_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="fpLiveStreamId")
    ] = UNSET
    r"""FastPix Live Stream ID is the unique identifier associated with a live stream video media within the FastPix Video platform.

    """

    live_stream_latency: Annotated[
        OptionalNullable[float], pydantic.Field(alias="liveStreamLatency")
    ] = UNSET
    r"""Live Stream Latency measures the average time taken from the point of ingest to the point of display for live stream video views.

    """

    longitude: OptionalNullable[str] = UNSET
    r"""Longitude denotes the geographical coordinate representing the east-west position of the viewer's location, truncated to one decimal place.

    """

    page_load_time: Annotated[
        OptionalNullable[int], pydantic.Field(alias="pageLoadTime")
    ] = UNSET
    r"""Page Load Time measures the time from when the user initiates loading the page to when all resources are loaded on the page.

    """

    page_context: Annotated[
        OptionalNullable[str], pydantic.Field(alias="pageContext")
    ] = UNSET
    r"""Page Context provides contextual information about the type of page being accessed.

    """

    view_page_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="viewPageUrl")
    ] = UNSET
    r"""View Page URL denotes the URL address of the web page where the video content is being accessed.

    """

    fp_playback_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="fpPlaybackId")
    ] = UNSET
    r"""FastPix Playback ID refers to the unique identifier associated with the playback instance of a video, particularly used in FastPix Video platform.

    """

    playback_score: Annotated[
        OptionalNullable[float], pydantic.Field(alias="playbackScore")
    ] = UNSET
    r"""Playback Success Score represents a numerical value indicating the success or quality of the video playback experience.

    """

    player_autoplay_on: Annotated[
        Optional[bool], pydantic.Field(alias="playerAutoplayOn")
    ] = None
    r"""Player Autoplay On indicates whether the video player automatically initiated playback of the video content.

    """

    error_code: Annotated[OptionalNullable[str], pydantic.Field(alias="errorCode")] = (
        UNSET
    )
    r"""Error Code is an identifier representing a specific type of error that occurred during video playback, potentially leading to playback failure.

    """

    error_message: Annotated[
        OptionalNullable[str], pydantic.Field(alias="errorMessage")
    ] = UNSET
    r"""Error Message is a descriptive message generated by the video player when an error occurs during playback, associated with an error code.

    """

    player_height: Annotated[
        OptionalNullable[PlayerHeight], pydantic.Field(alias="playerHeight")
    ] = UNSET
    r"""Player Height refers to the vertical dimension, measured in pixels, of the video player as it appears on the webpage.

    """

    player_instance_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="playerInstanceId")
    ] = UNSET
    r"""Player Instance ID is a unique identifier that distinguishes each instance of the Player class created when initializing a video.

    """

    player_language: Annotated[
        OptionalNullable[str], pydantic.Field(alias="playerLanguage")
    ] = UNSET
    r"""Player Language indicates the language used for text elements within the video player interface.

    """

    fp_sdk: Annotated[OptionalNullable[str], pydantic.Field(alias="fpSdk")] = UNSET
    r"""FastPix SDK Name identifies the name of the FastPix Player SDK utilized within the player workspace.

    """

    fp_sdk_version: Annotated[
        OptionalNullable[str], pydantic.Field(alias="fpSdkVersion")
    ] = UNSET
    r"""FastPix SDK Version specifies the version of the FastPix Player SDK integrated into the player.

    """

    player_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="playerName")
    ] = UNSET
    r"""Player Name serves to differentiate various configurations or types of players used across the website or application.

    """

    player_poster: Annotated[
        OptionalNullable[str], pydantic.Field(alias="playerPoster")
    ] = UNSET
    r"""Player Poster refers to the image displayed as a preview before the video playback begins.

    """

    player_preload_on: Annotated[
        Optional[bool], pydantic.Field(alias="playerPreloadOn")
    ] = None
    r"""Player Preload On indicates whether the player is configured to preload the video content upon page load.

    """

    player_remote_played: Annotated[
        Optional[bool], pydantic.Field(alias="playerRemotePlayed")
    ] = None
    r"""Player Remote Played specifies if the video is being remotely played to devices such as AirPlay or Chromecast, obtained from the SDK.

    """

    player_software_version: Annotated[
        OptionalNullable[str], pydantic.Field(alias="playerSoftwareVersion")
    ] = UNSET
    r"""Player Software Version indicates the version number of the player software installed.

    """

    player_software_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="playerSoftwareName")
    ] = UNSET
    r"""Player Software Name denotes the software utilized for video playback within the player workspace.

    """

    video_source_domain: Annotated[
        OptionalNullable[str], pydantic.Field(alias="videoSourceDomain")
    ] = UNSET
    r"""Video Source Domain identifies the domain from which the video source originates.

    """

    video_source_duration: Annotated[
        OptionalNullable[int], pydantic.Field(alias="videoSourceDuration")
    ] = UNSET
    r"""Video Source Duration represents the duration of the video source content, measured in milliseconds.

    """

    player_source_height: Annotated[
        OptionalNullable[int], pydantic.Field(alias="playerSourceHeight")
    ] = UNSET
    r"""Player Source Height denotes the vertical dimension, measured in pixels, of the source video content being transmitted to the player.

    """

    video_source_hostname: Annotated[
        OptionalNullable[str], pydantic.Field(alias="videoSourceHostname")
    ] = UNSET
    r"""Video Source Hostname represents the hostname of the video

    """

    video_source_stream_type: Annotated[
        OptionalNullable[str], pydantic.Field(alias="videoSourceStreamType")
    ] = UNSET
    r"""Video Source Stream Type denotes the type of stream used by the player, although it is currently unused.

    """

    video_source_type: Annotated[
        OptionalNullable[str], pydantic.Field(alias="videoSourceType")
    ] = UNSET
    r"""Video Source Type denotes the format of the video source as determined by the player, including formats

    """

    video_source_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="videoSourceUrl")
    ] = UNSET
    r"""Player Source URL refers to the URL of the video source accessed by the player.

    """

    player_source_width: Annotated[
        OptionalNullable[int], pydantic.Field(alias="playerSourceWidth")
    ] = UNSET
    r"""Source Width represents the width of the source video as perceived by the player, typically measured in pixels.

    """

    player_initialization_time: Annotated[
        OptionalNullable[int], pydantic.Field(alias="playerInitializationTime")
    ] = UNSET
    r"""Player Initialisation Time measures the duration, in milliseconds, from the initialization of the player within the webpage to its readiness to receive further instructions.

    """

    player_version: Annotated[
        OptionalNullable[str], pydantic.Field(alias="playerVersion")
    ] = UNSET
    r"""Player Version indicates the version of the player used to render the video content. It is often utilized for performance comparison between different player versions.

    """

    player_width: Annotated[
        OptionalNullable[PlayerWidth], pydantic.Field(alias="playerWidth")
    ] = UNSET
    r"""Player Width refers to the width of the player displayed within the webpage, measured in pixels.

    """

    render_quality_score: Annotated[
        OptionalNullable[float], pydantic.Field(alias="renderQualityScore")
    ] = UNSET
    r"""Render Quality Score is a decimal value representing the score indicating the perceived quality of the video.

    """

    buffer_ratio: Annotated[
        OptionalNullable[float], pydantic.Field(alias="bufferRatio")
    ] = UNSET
    r"""Buffer Ratio refers to the percentage of time during video playback where the viewer experiences buffering or rebuffering events.

    """

    stability_score: Annotated[
        OptionalNullable[float], pydantic.Field(alias="stabilityScore")
    ] = UNSET
    r"""Stability Score quantifies the smoothness of video playback, typically represented as a decimal value.

    """

    region: OptionalNullable[str] = UNSET
    r"""Region denotes the geographical region of the viewer accessing the video content.

    """

    session_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sessionId")] = (
        UNSET
    )
    r"""Session ID refers to the unique identifier tracking a viewer's session within the FastPix platform.

    """

    startup_score: Annotated[
        OptionalNullable[float], pydantic.Field(alias="startupScore")
    ] = UNSET
    r"""Startup Time Score evaluates the startup performance of the player, usually represented as a decimal value

    """

    sub_property_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="subPropertyId")
    ] = UNSET
    r"""Sub Property ID denotes the unique identifier assigned to FastPix properties, previously linked with a specific workspace.

    """

    video_startup_time: Annotated[
        OptionalNullable[int], pydantic.Field(alias="videoStartupTime")
    ] = UNSET
    r"""Video Startup Time measures the duration, in milliseconds, from the initialization of the player within the webpage to its readiness to receive further instructions.

    """

    updated_timestamp: Annotated[
        OptionalNullable[str], pydantic.Field(alias="updatedTimestamp")
    ] = UNSET
    r"""Updated Timestamp refers to when the record is updated to a particular Video.

    """

    used_full_screen: Annotated[
        Optional[bool], pydantic.Field(alias="usedFullScreen")
    ] = None
    r"""Used Fullscreen denotes whether the viewer utilized the full-screen mode while watching the video.

    """

    video_content_type: Annotated[
        OptionalNullable[str], pydantic.Field(alias="videoContentType")
    ] = UNSET
    r"""Video Content Type specifies the classification of the video content.

    """

    video_duration: Annotated[
        OptionalNullable[int], pydantic.Field(alias="videoDuration")
    ] = UNSET
    r"""Video Duration represents the length of the video, provided in milliseconds, typically supplied to FastPix via custom metadata.

    """

    video_id: Annotated[OptionalNullable[str], pydantic.Field(alias="videoId")] = UNSET
    r"""Video ID refers to an internal identifier assigned by the user or system to uniquely identify a particular video.

    """

    video_language: Annotated[
        OptionalNullable[str], pydantic.Field(alias="videoLanguage")
    ] = UNSET
    r"""Video Language denotes the primary audio language of the video content, assuming it remains unchanged after playback initiation.

    """

    video_series: Annotated[
        OptionalNullable[str], pydantic.Field(alias="videoSeries")
    ] = UNSET
    r"""Video Series denotes the name of a series to which the video content belongs.

    """

    video_startup_failed: Annotated[
        Optional[bool], pydantic.Field(alias="videoStartupFailed")
    ] = None
    r"""Video Startup Failure is a boolean metric indicating whether a viewer encountered an error before the first frame of the video commenced playback.

    """

    video_title: Annotated[
        OptionalNullable[str], pydantic.Field(alias="videoTitle")
    ] = UNSET
    r"""Video Title refers to the title of the video content being viewed.

    """

    avg_request_latency: Annotated[
        OptionalNullable[float], pydantic.Field(alias="avgRequestLatency")
    ] = UNSET
    r"""Average Request Latency average time it takes for a request to be made and processed during video playback

    """

    avg_request_throughput: Annotated[
        OptionalNullable[float], pydantic.Field(alias="avgRequestThroughput")
    ] = UNSET
    r"""Average Request Throughput refers to the average throughput or data transfer rate of HTTP requests made during video playback

    """

    drm_type: Annotated[OptionalNullable[str], pydantic.Field(alias="drmType")] = UNSET
    r"""DRM Type indicates the type of Digital Rights Management (DRM) utilized during video playback

    """

    dropped_frame_count: Annotated[
        OptionalNullable[int], pydantic.Field(alias="droppedFrameCount")
    ] = UNSET
    r"""Dropped Frame Count represents the number of frames dropped by the video player during playback.

    """

    view_end: Annotated[OptionalNullable[str], pydantic.Field(alias="viewEnd")] = UNSET
    r"""View End refers to the date and time, in Coordinated Universal Time (UTC), when the video viewing session concluded.

    """

    view_has_ad: Annotated[Optional[bool], pydantic.Field(alias="viewHasAd")] = None
    r"""View Has Ad is a boolean metric indicating whether an advertisement played or attempted to play during the video view.

    """

    view_id: Annotated[Optional[str], pydantic.Field(alias="viewId")] = None
    r"""View ID is a unique identifier assigned to each individual video viewing session.

    """

    max_downscaling: Annotated[
        OptionalNullable[float], pydantic.Field(alias="maxDownscaling")
    ] = UNSET
    r"""Maximum Downscale Percentage represents the highest percentage of downscaling applied to the video during the view.

    """

    view_max_playhead_position: Annotated[
        OptionalNullable[int], pydantic.Field(alias="viewMaxPlayheadPosition")
    ] = UNSET
    r"""View Max Playhead Position represents the furthest point reached by the playhead during the video view, measured in milliseconds.

    """

    max_request_latency: Annotated[
        OptionalNullable[float], pydantic.Field(alias="maxRequestLatency")
    ] = UNSET
    r"""Max request Latency refers to the maximum rate of data transfer (throughput) during requests made by the playback.

    """

    max_upscaling: Annotated[
        OptionalNullable[float], pydantic.Field(alias="maxUpscaling")
    ] = UNSET
    r"""Maximum Upscale Percentage represents the highest percentage of upscaling applied to the video during the view.

    """

    view_playing_time: Annotated[
        OptionalNullable[int], pydantic.Field(alias="viewPlayingTime")
    ] = UNSET
    r"""Playing Time denotes the total duration of time the video content was actively playing during the view, excluding time spent buffering, seeking, or joining.

    """

    view_seeked_count: Annotated[
        OptionalNullable[int], pydantic.Field(alias="viewSeekedCount")
    ] = UNSET
    r"""View Seeked Count signifies the number of times the viewer attempted to seek to a new location within the video.

    """

    view_seeked_duration: Annotated[
        OptionalNullable[int], pydantic.Field(alias="viewSeekedDuration")
    ] = UNSET
    r"""View Seeked Duration indicates the total duration of time spent waiting for playback to resume after the viewer seeks to a new location. Seek Latency metric in the Dashboard is derived by dividing this value by the view_seek_count.

    """

    view_start: Annotated[OptionalNullable[str], pydantic.Field(alias="viewStart")] = (
        UNSET
    )
    r"""View Start refers to the date and time, in Coordinated Universal Time (UTC), when the video viewing session commenced.

    """

    view_total_content_playback_time: Annotated[
        OptionalNullable[int], pydantic.Field(alias="viewTotalContentPlaybackTime")
    ] = UNSET
    r"""View Total content Playback Time represents the cumulative duration of video content watched by the viewer, measured in milliseconds. This metric is internally utilized to calculate upscale and downscale percentages.

    """

    avg_downscaling: Annotated[
        OptionalNullable[float], pydantic.Field(alias="avgDownscaling")
    ] = UNSET
    r"""Average Downscaling refers to the average reduction in video resolution or quality during the playback of video content.

    """

    avg_upscaling: Annotated[
        OptionalNullable[float], pydantic.Field(alias="avgUpscaling")
    ] = UNSET
    r"""Average Upscaling refers to the average resolution of the video source is lower than the resolution of the playback device or screen.

    """

    browser_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="browserName")
    ] = UNSET
    r"""Browser denotes the software application utilized by the viewer to access and watch the video content

    """

    browser_version: Annotated[
        OptionalNullable[str], pydantic.Field(alias="browserVersion")
    ] = UNSET
    r"""Browser version signifies the specific version of the browser software employed by the viewer

    """

    connectiontype: OptionalNullable[str] = UNSET
    r"""Connection Type signifies the type of network connection utilized by the viewer's device

    """

    device_type: Annotated[
        OptionalNullable[str], pydantic.Field(alias="deviceType")
    ] = UNSET
    r"""Device Type denotes the classification of the device used by the viewer

    """

    device_manufacturer: Annotated[
        OptionalNullable[str], pydantic.Field(alias="deviceManufacturer")
    ] = UNSET
    r"""Device Manufacturer indicates the brand or manufacturer of the device used by the viewer.

    """

    device_model: Annotated[
        OptionalNullable[str], pydantic.Field(alias="deviceModel")
    ] = UNSET
    r"""Device Model represents the specific model of the device used by the viewer.

    """

    device_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="deviceName")
    ] = UNSET
    r"""Device Name refers to the name or label assigned to the device used by the viewer.

    """

    quality_of_experience_score: Annotated[
        OptionalNullable[float], pydantic.Field(alias="qualityOfExperienceScore")
    ] = UNSET
    r"""Quality Of Experience Score quantifies the overall viewer experience based on various metrics, providing a decimal score to assess the quality of the viewing experience.

    """

    os_name: Annotated[OptionalNullable[str], pydantic.Field(alias="osName")] = UNSET
    r"""Operating System signifies the name of software platform utilized by the viewer.

    """

    os_version: Annotated[Optional[str], pydantic.Field(alias="osVersion")] = None
    r"""Operating System Version specifies the specific version of the operating system being used by the viewer

    """

    user_agent: Annotated[OptionalNullable[str], pydantic.Field(alias="userAgent")] = (
        UNSET
    )
    r"""User Agent represents the user agent string transmitted by the viewer's device to identify itself to the server, typically including information about the device and browser.

    """

    viewer_id: Annotated[OptionalNullable[str], pydantic.Field(alias="viewerId")] = (
        UNSET
    )
    r"""Viewer ID refers to a customer-defined identifier representing the viewer who is watching the video stream. It should be anonymized and not contain any personally identifiable information.

    """

    total_watch_time: Annotated[
        OptionalNullable[int], pydantic.Field(alias="totalWatchTime")
    ] = UNSET
    r"""Total Watch Time denotes the total duration of video content watched by the viewer, encompassing startup time, playing time, and potential rebuffering time, measured in milliseconds.

    """

    average_bitrate: Annotated[
        OptionalNullable[float], pydantic.Field(alias="averageBitrate")
    ] = UNSET
    r"""Average Bitrate represents the average bitrate of the video content watched by the viewer, expressed in bits per second (bps). This metric provides insight into the quality of the video stream.

    """

    jump_latency: Annotated[
        OptionalNullable[float], pydantic.Field(alias="jumpLatency")
    ] = UNSET
    r"""Jump Latency refers to the delay or latency experienced when there is a jump or seek action performed by the viewer while watching a video.

    """

    player_resolution: Annotated[
        OptionalNullable[str], pydantic.Field(alias="playerResolution")
    ] = UNSET
    r"""Player Resolution refers to the resolution of the video player window or viewport where the video content is being displayed.

    """

    video_resolution: Annotated[
        OptionalNullable[str], pydantic.Field(alias="videoResolution")
    ] = UNSET
    r"""videoResolution refers to the resolution of the video being played.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "asnName",
            "asnId",
            "mediaId",
            "bufferCount",
            "bufferFill",
            "BufferFrequency",
            "cdn",
            "city",
            "continent",
            "countryCode",
            "country",
            "custom1",
            "custom2",
            "custom3",
            "custom4",
            "custom5",
            "custom6",
            "custom7",
            "custom8",
            "custom9",
            "custom10",
            "workspaceId",
            "events",
            "exitBeforeVideoStart",
            "experimentName",
            "insertTimestamp",
            "latitude",
            "fpLiveStreamId",
            "liveStreamLatency",
            "longitude",
            "pageLoadTime",
            "pageContext",
            "viewPageUrl",
            "fpPlaybackId",
            "playbackScore",
            "playerAutoplayOn",
            "errorCode",
            "errorMessage",
            "playerHeight",
            "playerInstanceId",
            "playerLanguage",
            "fpSdk",
            "fpSdkVersion",
            "playerName",
            "playerPoster",
            "playerPreloadOn",
            "playerRemotePlayed",
            "playerSoftwareVersion",
            "playerSoftwareName",
            "videoSourceDomain",
            "videoSourceDuration",
            "playerSourceHeight",
            "videoSourceHostname",
            "videoSourceStreamType",
            "videoSourceType",
            "videoSourceUrl",
            "playerSourceWidth",
            "playerInitializationTime",
            "playerVersion",
            "playerWidth",
            "renderQualityScore",
            "bufferRatio",
            "stabilityScore",
            "region",
            "sessionId",
            "startupScore",
            "subPropertyId",
            "videoStartupTime",
            "updatedTimestamp",
            "usedFullScreen",
            "videoContentType",
            "videoDuration",
            "videoId",
            "videoLanguage",
            "videoSeries",
            "videoStartupFailed",
            "videoTitle",
            "avgRequestLatency",
            "avgRequestThroughput",
            "drmType",
            "droppedFrameCount",
            "viewEnd",
            "viewHasAd",
            "viewId",
            "maxDownscaling",
            "viewMaxPlayheadPosition",
            "maxRequestLatency",
            "maxUpscaling",
            "viewPlayingTime",
            "viewSeekedCount",
            "viewSeekedDuration",
            "viewStart",
            "viewTotalContentPlaybackTime",
            "avgDownscaling",
            "avgUpscaling",
            "browserName",
            "browserVersion",
            "connectiontype",
            "deviceType",
            "deviceManufacturer",
            "deviceModel",
            "deviceName",
            "qualityOfExperienceScore",
            "osName",
            "osVersion",
            "userAgent",
            "viewerId",
            "totalWatchTime",
            "averageBitrate",
            "jumpLatency",
            "playerResolution",
            "videoResolution",
        ]
        nullable_fields = [
            "asnName",
            "asnId",
            "mediaId",
            "bufferCount",
            "bufferFill",
            "BufferFrequency",
            "cdn",
            "city",
            "continent",
            "countryCode",
            "country",
            "custom1",
            "custom2",
            "custom3",
            "custom4",
            "custom5",
            "custom6",
            "custom7",
            "custom8",
            "custom9",
            "custom10",
            "latitude",
            "fpLiveStreamId",
            "liveStreamLatency",
            "longitude",
            "pageLoadTime",
            "pageContext",
            "viewPageUrl",
            "fpPlaybackId",
            "playbackScore",
            "errorCode",
            "errorMessage",
            "playerHeight",
            "playerInstanceId",
            "playerLanguage",
            "fpSdk",
            "fpSdkVersion",
            "playerName",
            "playerPoster",
            "playerSoftwareVersion",
            "playerSoftwareName",
            "videoSourceDomain",
            "videoSourceDuration",
            "playerSourceHeight",
            "videoSourceHostname",
            "videoSourceStreamType",
            "videoSourceType",
            "videoSourceUrl",
            "playerSourceWidth",
            "playerInitializationTime",
            "playerVersion",
            "playerWidth",
            "renderQualityScore",
            "bufferRatio",
            "stabilityScore",
            "region",
            "sessionId",
            "startupScore",
            "subPropertyId",
            "videoStartupTime",
            "updatedTimestamp",
            "videoContentType",
            "videoDuration",
            "videoId",
            "videoLanguage",
            "videoSeries",
            "videoTitle",
            "avgRequestLatency",
            "avgRequestThroughput",
            "drmType",
            "droppedFrameCount",
            "viewEnd",
            "maxDownscaling",
            "viewMaxPlayheadPosition",
            "maxRequestLatency",
            "maxUpscaling",
            "viewPlayingTime",
            "viewSeekedCount",
            "viewSeekedDuration",
            "viewStart",
            "viewTotalContentPlaybackTime",
            "avgDownscaling",
            "avgUpscaling",
            "browserName",
            "browserVersion",
            "connectiontype",
            "deviceType",
            "deviceManufacturer",
            "deviceModel",
            "deviceName",
            "qualityOfExperienceScore",
            "osName",
            "userAgent",
            "viewerId",
            "totalWatchTime",
            "averageBitrate",
            "jumpLatency",
            "playerResolution",
            "videoResolution",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
