"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class ViewsListTypedDict(TypedDict):
    view_id: str
    r"""The unique identifier for the viewing session of the user.

    """
    operating_system: Nullable[str]
    r"""Operating System signifies the software platform utilized by the viewer

    """
    application: Nullable[str]
    r"""The browser name of the viewer.

    """
    view_start_time: Nullable[str]
    r"""The start timestamp of the video view.

    """
    view_end_time: Nullable[str]
    r"""The end timestamp of the video view.

    """
    video_title: Nullable[str]
    r"""The title of the Video.

    """
    country: Nullable[str]
    r"""Country of the viewer.

    """
    error_code: NotRequired[Nullable[str]]
    r"""The code which represents specific issues or failures that occur during playback. These can be implementation specific.

    """
    error_message: NotRequired[Nullable[str]]
    r"""The notifications or messages that inform users or developers about issues or failures that have occurred during the playback representing error codes.

    """
    error_id: NotRequired[Nullable[int]]
    r"""The unique identifier which identifies each type of error that occurs.

    """
    view_watch_time: NotRequired[Nullable[float]]
    r"""The watch time represents the time spent watching the video including staruptime, playback time ,buffering time.

    """
    qoe_score: NotRequired[Nullable[float]]
    r"""The viewer experience encapsulated in the form of score while watching the video.

    """


class ViewsList(BaseModel):
    view_id: Annotated[str, pydantic.Field(alias="viewId")]
    r"""The unique identifier for the viewing session of the user.

    """

    operating_system: Annotated[Nullable[str], pydantic.Field(alias="operatingSystem")]
    r"""Operating System signifies the software platform utilized by the viewer

    """

    application: Nullable[str]
    r"""The browser name of the viewer.

    """

    view_start_time: Annotated[Nullable[str], pydantic.Field(alias="viewStartTime")]
    r"""The start timestamp of the video view.

    """

    view_end_time: Annotated[Nullable[str], pydantic.Field(alias="viewEndTime")]
    r"""The end timestamp of the video view.

    """

    video_title: Annotated[Nullable[str], pydantic.Field(alias="videoTitle")]
    r"""The title of the Video.

    """

    country: Nullable[str]
    r"""Country of the viewer.

    """

    error_code: Annotated[OptionalNullable[str], pydantic.Field(alias="errorCode")] = (
        UNSET
    )
    r"""The code which represents specific issues or failures that occur during playback. These can be implementation specific.

    """

    error_message: Annotated[
        OptionalNullable[str], pydantic.Field(alias="errorMessage")
    ] = UNSET
    r"""The notifications or messages that inform users or developers about issues or failures that have occurred during the playback representing error codes.

    """

    error_id: Annotated[OptionalNullable[int], pydantic.Field(alias="errorId")] = UNSET
    r"""The unique identifier which identifies each type of error that occurs.

    """

    view_watch_time: Annotated[
        OptionalNullable[float], pydantic.Field(alias="viewWatchTime")
    ] = UNSET
    r"""The watch time represents the time spent watching the video including staruptime, playback time ,buffering time.

    """

    qoe_score: Annotated[OptionalNullable[float], pydantic.Field(alias="QoeScore")] = (
        UNSET
    )
    r"""The viewer experience encapsulated in the form of score while watching the video.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "errorCode",
            "errorMessage",
            "errorId",
            "viewWatchTime",
            "QoeScore",
        ]
        nullable_fields = [
            "operatingSystem",
            "application",
            "viewStartTime",
            "viewEndTime",
            "videoTitle",
            "errorCode",
            "errorMessage",
            "errorId",
            "country",
            "viewWatchTime",
            "QoeScore",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
