"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from __future__ import annotations
from ..types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


WatermarkInputType = Literal["watermark",]
r"""Type of overlay (currently only supports 'watermark')."""


XAlign = Literal[
    "left",
    "center",
    "right",
]
r"""Horizontal alignment of the watermark."""


YAlign = Literal[
    "top",
    "middle",
    "bottom",
]
r"""Vertical alignment of the watermark."""


class PlacementTypedDict(TypedDict):
    x_align: NotRequired[XAlign]
    r"""Horizontal alignment of the watermark."""
    x_margin: NotRequired[str]
    r"""Horizontal margin from the edge of the video."""
    y_align: NotRequired[YAlign]
    r"""Vertical alignment of the watermark."""
    y_margin: NotRequired[str]
    r"""Vertical margin from the edge of the video."""


class Placement(BaseModel):
    x_align: Annotated[Optional[XAlign], pydantic.Field(alias="xAlign")] = None
    r"""Horizontal alignment of the watermark."""

    x_margin: Annotated[Optional[str], pydantic.Field(alias="xMargin")] = None
    r"""Horizontal margin from the edge of the video."""

    y_align: Annotated[Optional[YAlign], pydantic.Field(alias="yAlign")] = None
    r"""Vertical alignment of the watermark."""

    y_margin: Annotated[Optional[str], pydantic.Field(alias="yMargin")] = None
    r"""Vertical margin from the edge of the video."""


class WatermarkInputTypedDict(TypedDict):
    type: NotRequired[WatermarkInputType]
    r"""Type of overlay (currently only supports 'watermark')."""
    url: NotRequired[str]
    r"""URL of the watermark image."""
    placement: NotRequired[PlacementTypedDict]
    width: NotRequired[str]
    r"""Width of the watermark in percentage or pixels."""
    height: NotRequired[str]
    r"""Height of the watermark in percentage or pixels."""
    opacity: NotRequired[str]
    r"""Opacity of the watermark in percentage."""


class WatermarkInput(BaseModel):
    type: Optional[WatermarkInputType] = None
    r"""Type of overlay (currently only supports 'watermark')."""

    url: Optional[str] = None
    r"""URL of the watermark image."""

    placement: Optional[Placement] = None

    width: Optional[str] = None
    r"""Width of the watermark in percentage or pixels."""

    height: Optional[str] = None
    r"""Height of the watermark in percentage or pixels."""

    opacity: Optional[str] = None
    r"""Opacity of the watermark in percentage."""
