"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from .basesdk import BaseSDK
from .httpclient import AsyncHttpClient, ClientOwner, HttpClient, close_clients
from .sdkconfiguration import SDKConfiguration
from .utils.logger import Logger, get_default_logger
from .utils.retries import RetryConfig
from . import models, utils
from ._hooks import SDKHooks
from .types import OptionalNullable, UNSET
import httpx
import importlib
import sys
from typing import Callable, Dict, Optional, TYPE_CHECKING, Union, cast
import weakref

if TYPE_CHECKING:
    from .dimensions import Dimensions
    from .drm_configurations import DRMConfigurations
    from .errors import Errors
    from .in_video_ai_features import InVideoAIFeatures
    from .input_video import InputVideo
    from .live_playback import LivePlayback
    from .manage_live_stream import ManageLiveStream
    from .manage_videos import ManageVideos
    from .metrics import Metrics
    from .playback import Playback
    from .playlist import Playlist
    from .signing_keys import SigningKeys
    from .simulcast_stream import SimulcastStream
    from .start_live_stream import StartLiveStream
    from .views_sdk import ViewsSDK


class Fastpix(BaseSDK):
    r"""FASTPIX API'S: FastPix provides a comprehensive set of APIs that enable developers to manage both **on-demand media (video/audio)** and **live streaming experiences**, with built-in security features through **cryptographic signing keys**. These APIs cover the full lifecycle of content creation, management, distribution, playback, and secure access, making them ideal for building scalable video-first applications.
    ### Media APIs (Video & Audio on Demand)
    The **Media APIs** allow developers to create, retrieve, update, and delete media files, as well as manage metadata, playback settings, and additional tracks such as audio or subtitles. With these endpoints, developers can:
    - Upload videos directly or create media from URLs.   - Manage playback permissions and configure playback IDs.   - Add multilingual audio or subtitle tracks for global audiences.   - Build robust video-on-demand (VOD) and audio-on-demand (AOD) libraries.
    **Use case scenarios**   - **Video-on-Demand Platforms:** Manage large content libraries for streaming services.   - **E-Learning Solutions:** Upload and organize lecture videos, metadata, and playback settings.   - **Multilingual Content Delivery:** Add multiple language tracks or subtitles to serve global users.
    ### Live Stream APIs
    The **Live Stream APIs** simplify the process of creating, managing, and distributing live content. Developers can initiate broadcasts, configure stream settings, and extend streams to external platforms through simulcasting. These endpoints also support real-time interaction and customization of live events.
    - Start and manage live broadcasts programmatically.   - Control stream metadata, privacy, and playback options.   - Simulcast to platforms like YouTube, Facebook, or Twitch.   - Update stream details and manage live playback IDs in real time.
    **Use case scenarios**   - **Event Broadcasting:** Enable organizers to set up live streams for conferences, concerts, or webinars.   - **Creator Platforms:** Provide streamers with tools for broadcasting gameplay, tutorials, or vlogs with simulcasting support.   - **Corporate Streaming:** Deliver secure internal town halls or meetings with privacy and playback controls.
    ### Video Data APIs
    The **Video Data APIs** Provide insights into viewer interactions, performance metrics, and playback errors to optimize content delivery and user experience.

    - Track video views, unique viewers, and engagement metrics
    - Identify top-performing content and usage patterns
    - Break down data by browser, device, or geography
    - Detect playback errors and performance issues
    - Enable data-driven content strategy decisions

    **Use case scenarios**
    - Analytics Dashboards: Monitor performance across content libraries
    - Quality Monitoring: Diagnose and resolve playback issues
    - Content Strategy Optimization: Identify high-value content
    - User Behavior Insights: Understand audience interactions

    ### Signing Keys
    FastPix also provides endpoints for managing **cryptographic signing keys**, which are essential for securely signing and verifying tokens, such as JSON Web Tokens (JWTs). These keys are critical for authenticating and authorizing API requests, as well as for protecting access to media assets.
    - **Private key:** Used to create digital signatures (kept secret).   - **Public key:** Used to verify digital signatures (shared for verification).
    By rotating and managing signing keys regularly, developers can maintain strong security practices and prevent unauthorized access.
    **Use case scenarios**   - **Token-based authentication:** Validate user access to premium or subscription-based content.   - **Key rotation:** Regularly rotate keys to reduce risk of compromise.   - **Protect intellectual property:** Prevent unauthorized distribution of valuable media assets.   - **Control usage:** Restrict access to specific users, groups, or contexts.   - **Prevent tampering:** Ensure requested assets have not been modified.   - **Time-bound access:** Enable signed URLs with expiration for controlled viewing windows.
    """

    input_video: "InputVideo"
    manage_videos: "ManageVideos"
    in_video_ai_features: "InVideoAIFeatures"
    playback: "Playback"
    playlist: "Playlist"
    drm_configurations: "DRMConfigurations"
    start_live_stream: "StartLiveStream"
    manage_live_stream: "ManageLiveStream"
    live_playback: "LivePlayback"
    simulcast_stream: "SimulcastStream"
    signing_keys: "SigningKeys"
    views: "ViewsSDK"
    dimensions: "Dimensions"
    metrics: "Metrics"
    errors: "Errors"
    _sub_sdk_map = {
        "input_video": ("Fastpix.input_video", "InputVideo"),
        "manage_videos": ("Fastpix.manage_videos", "ManageVideos"),
        "in_video_ai_features": (
            "Fastpix.in_video_ai_features",
            "InVideoAIFeatures",
        ),
        "playback": ("Fastpix.playback", "Playback"),
        "playlist": ("Fastpix.playlist", "Playlist"),
        "drm_configurations": (
            "Fastpix.drm_configurations",
            "DRMConfigurations",
        ),
        "start_live_stream": ("Fastpix.start_live_stream", "StartLiveStream"),
        "manage_live_stream": ("Fastpix.manage_live_stream", "ManageLiveStream"),
        "live_playback": ("Fastpix.live_playback", "LivePlayback"),
        "simulcast_stream": ("Fastpix.simulcast_stream", "SimulcastStream"),
        "signing_keys": ("Fastpix.signing_keys", "SigningKeys"),
        "views": ("Fastpix.views_sdk", "ViewsSDK"),
        "dimensions": ("Fastpix.dimensions", "Dimensions"),
        "metrics": ("Fastpix.metrics", "Metrics"),
        "errors": ("Fastpix.errors", "Errors"),
    }

    def __init__(
        self,
        security: Optional[
            Union[models.Security, Callable[[], models.Security]]
        ] = None,
        server_idx: Optional[int] = None,
        server_url: Optional[str] = None,
        url_params: Optional[Dict[str, str]] = None,
        client: Optional[HttpClient] = None,
        async_client: Optional[AsyncHttpClient] = None,
        retry_config: OptionalNullable[RetryConfig] = UNSET,
        timeout_ms: Optional[int] = None,
        debug_logger: Optional[Logger] = None,
    ) -> None:
        r"""Instantiates the SDK configuring it with the provided parameters.

        :param security: The security details required for authentication
        :param server_idx: The index of the server to use for all methods
        :param server_url: The server URL to use for all methods
        :param url_params: Parameters to optionally template the server URL with
        :param client: The HTTP client to use for all synchronous methods
        :param async_client: The Async HTTP client to use for all asynchronous methods
        :param retry_config: The retry configuration to use for all supported methods
        :param timeout_ms: Optional request timeout applied to each operation in milliseconds
        """
        client_supplied = True
        if client is None:
            client = httpx.Client(follow_redirects=True)
            client_supplied = False

        assert issubclass(
            type(client), HttpClient
        ), "The provided client must implement the HttpClient protocol."

        async_client_supplied = True
        if async_client is None:
            async_client = httpx.AsyncClient(follow_redirects=True)
            async_client_supplied = False

        if debug_logger is None:
            debug_logger = get_default_logger()

        assert issubclass(
            type(async_client), AsyncHttpClient
        ), "The provided async_client must implement the AsyncHttpClient protocol."

        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)

        BaseSDK.__init__(
            self,
            SDKConfiguration(
                client=client,
                client_supplied=client_supplied,
                async_client=async_client,
                async_client_supplied=async_client_supplied,
                security=security,
                server_url=server_url,
                server_idx=server_idx,
                retry_config=retry_config,
                timeout_ms=timeout_ms,
                debug_logger=debug_logger,
            ),
            parent_ref=self,
        )

        hooks = SDKHooks()

        # pylint: disable=protected-access
        self.sdk_configuration.__dict__["_hooks"] = hooks

        self.sdk_configuration = hooks.sdk_init(self.sdk_configuration)

        weakref.finalize(
            self,
            close_clients,
            cast(ClientOwner, self.sdk_configuration),
            self.sdk_configuration.client,
            self.sdk_configuration.client_supplied,
            self.sdk_configuration.async_client,
            self.sdk_configuration.async_client_supplied,
        )

    def dynamic_import(self, modname, retries=3):
        for attempt in range(retries):
            try:
                return importlib.import_module(modname)
            except KeyError:
                # Clear any half-initialized module and retry
                sys.modules.pop(modname, None)
                if attempt == retries - 1:
                    break
        raise KeyError(f"Failed to import module '{modname}' after {retries} attempts")

    def __getattr__(self, name: str):
        if name in self._sub_sdk_map:
            module_path, class_name = self._sub_sdk_map[name]
            try:
                module = self.dynamic_import(module_path)
                klass = getattr(module, class_name)
                instance = klass(self.sdk_configuration, parent_ref=self)
                setattr(self, name, instance)
                return instance
            except ImportError as e:
                raise AttributeError(
                    f"Failed to import module {module_path} for attribute {name}: {e}"
                ) from e
            except AttributeError as e:
                raise AttributeError(
                    f"Failed to find class {class_name} in module {module_path} for attribute {name}: {e}"
                ) from e

        raise AttributeError(
            f"'{type(self).__name__}' object has no attribute '{name}'"
        )

    def __dir__(self):
        default_attrs = list(super().__dir__())
        lazy_attrs = list(self._sub_sdk_map.keys())
        return sorted(list(set(default_attrs + lazy_attrs)))

    def __enter__(self):
        return self

    async def __aenter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.client is not None
            and not self.sdk_configuration.client_supplied
        ):
            self.sdk_configuration.client.close()
        self.sdk_configuration.client = None

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.async_client is not None
            and not self.sdk_configuration.async_client_supplied
        ):
            await self.sdk_configuration.async_client.aclose()
        self.sdk_configuration.async_client = None
