"""Code generated by fastpix (https://fastpix.io). DO NOT EDIT."""

from .basesdk import BaseSDK
from . import errors, models, utils
from ._hooks import HookContext
from .types import OptionalNullable, UNSET
from .utils import get_security_from_env
from .utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Dict, Mapping, Optional


class SimulcastStream(BaseSDK):
    def create_simulcast_of_stream(
        self,
        *,
        stream_id: str,
        url: Optional[str] = None,
        stream_key: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SimulcastResponseData:
        r"""Create a simulcast

        Lets you to create a simulcast for a parent live stream. Simulcasting enables you to broadcast the live stream to multiple social platforms simultaneously (e.g., YouTube, Facebook, or Twitch). This feature is useful for expanding your audience reach across different platforms. However, a simulcast can only be created when the parent live stream is in idle state (i.e., not currently live or disabled). Additionally, only one simulcast target can be created per API call.
        #### How it works

        1. Upon calling this endpoint, you need to provide the parent `streamId` and the details of the simulcast target (platform and credentials). The system will generate a unique `simulcastId`, which can be used to manage the simulcast later.

        2. To notify your application about the status of simulcast related events check for the <a href=\"https://docs.fastpix.io/docs/webhooks-collection#simulcast-target-events\">webhooks for simulcast</a> target events.

        #### Example
        An event manager sets up a live stream for a virtual conference and wants to simulcast the stream on YouTube and Facebook Live. They first create the primary live stream in FastPix, ensuring it's in the idle state. Then, they use the API to create a simulcast target for YouTube.

        Related guide: <a href=\"https://docs.fastpix.io/docs/simulcast-to-3rd-party-platforms\">Simulcast to 3rd party platforms</a>

        :param stream_id: Upon creating a new live stream, FastPix assigns a unique identifier to the stream.
        :param url: The RTMPS hostname, combined with the application name, is crucial for connecting to third-party live streaming services and transmitting the live stream.
        :param stream_key: A unique stream key is generated for streaming, allowing the user to start streaming on any third-party platform using this key.
        :param metadata: You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateSimulcastOfStreamRequest(
            stream_id=stream_id,
            simulcast_request=models.SimulcastRequest(
                url=url,
                stream_key=stream_key,
                metadata=metadata,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/live/streams/{streamId}/simulcast",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.simulcast_request, False, False, "json", models.SimulcastRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create-simulcast-of-stream",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.SimulcastResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.SimulcastUnavailableErrorData, http_res
            )
            raise errors.SimulcastUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.LiveNotFoundErrorData, http_res
            )
            raise errors.LiveNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def create_simulcast_of_stream_async(
        self,
        *,
        stream_id: str,
        url: Optional[str] = None,
        stream_key: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SimulcastResponseData:
        r"""Create a simulcast

        Lets you to create a simulcast for a parent live stream. Simulcasting enables you to broadcast the live stream to multiple social platforms simultaneously (e.g., YouTube, Facebook, or Twitch). This feature is useful for expanding your audience reach across different platforms. However, a simulcast can only be created when the parent live stream is in idle state (i.e., not currently live or disabled). Additionally, only one simulcast target can be created per API call.
        #### How it works

        1. Upon calling this endpoint, you need to provide the parent `streamId` and the details of the simulcast target (platform and credentials). The system will generate a unique `simulcastId`, which can be used to manage the simulcast later.

        2. To notify your application about the status of simulcast related events check for the <a href=\"https://docs.fastpix.io/docs/webhooks-collection#simulcast-target-events\">webhooks for simulcast</a> target events.

        #### Example
        An event manager sets up a live stream for a virtual conference and wants to simulcast the stream on YouTube and Facebook Live. They first create the primary live stream in FastPix, ensuring it's in the idle state. Then, they use the API to create a simulcast target for YouTube.

        Related guide: <a href=\"https://docs.fastpix.io/docs/simulcast-to-3rd-party-platforms\">Simulcast to 3rd party platforms</a>

        :param stream_id: Upon creating a new live stream, FastPix assigns a unique identifier to the stream.
        :param url: The RTMPS hostname, combined with the application name, is crucial for connecting to third-party live streaming services and transmitting the live stream.
        :param stream_key: A unique stream key is generated for streaming, allowing the user to start streaming on any third-party platform using this key.
        :param metadata: You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateSimulcastOfStreamRequest(
            stream_id=stream_id,
            simulcast_request=models.SimulcastRequest(
                url=url,
                stream_key=stream_key,
                metadata=metadata,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/live/streams/{streamId}/simulcast",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.simulcast_request, False, False, "json", models.SimulcastRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create-simulcast-of-stream",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.SimulcastResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.SimulcastUnavailableErrorData, http_res
            )
            raise errors.SimulcastUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.LiveNotFoundErrorData, http_res
            )
            raise errors.LiveNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def delete_simulcast_of_stream(
        self,
        *,
        stream_id: str,
        simulcast_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SimulcastdeleteResponse:
        r"""Delete a simulcast

        Allows you to delete a simulcast using its unique `simulcastId`, which was returned during the simulcast creation process. Deleting a simulcast stops the broadcast to the associated platform, but the parent stream will continue to run if it is live. This action is irreversible, and a new simulcast would need to be created if you want to resume streaming to the same platform.

        Webhook event: <a href=\"https://docs.fastpix.io/docs/live-events#videolive_streamsimulcast_targetdeleted\">video.live_stream.simulcast_target.deleted</a>


        #### Example
        A broadcaster needs to stop simulcasting to one platform due to technical difficulties while keeping the stream active on others. For instance, a tech company is simulcasting a product launch on multiple platforms. Midway through the event, they decide to stop the simulcast on Facebook due to performance issues, but keep it running on YouTube. They call this API to delete the Facebook simulcast target.

        :param stream_id: Upon creating a new live stream, FastPix assigns a unique identifier to the stream.
        :param simulcast_id: When you create the new simulcast, FastPix assign a universal unique identifier which can contain a maximum of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteSimulcastOfStreamRequest(
            stream_id=stream_id,
            simulcast_id=simulcast_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/live/streams/{streamId}/simulcast/{simulcastId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete-simulcast-of-stream",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SimulcastdeleteResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorSimulcastData, http_res
            )
            raise errors.NotFoundErrorSimulcast(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def delete_simulcast_of_stream_async(
        self,
        *,
        stream_id: str,
        simulcast_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SimulcastdeleteResponse:
        r"""Delete a simulcast

        Allows you to delete a simulcast using its unique `simulcastId`, which was returned during the simulcast creation process. Deleting a simulcast stops the broadcast to the associated platform, but the parent stream will continue to run if it is live. This action is irreversible, and a new simulcast would need to be created if you want to resume streaming to the same platform.

        Webhook event: <a href=\"https://docs.fastpix.io/docs/live-events#videolive_streamsimulcast_targetdeleted\">video.live_stream.simulcast_target.deleted</a>


        #### Example
        A broadcaster needs to stop simulcasting to one platform due to technical difficulties while keeping the stream active on others. For instance, a tech company is simulcasting a product launch on multiple platforms. Midway through the event, they decide to stop the simulcast on Facebook due to performance issues, but keep it running on YouTube. They call this API to delete the Facebook simulcast target.

        :param stream_id: Upon creating a new live stream, FastPix assigns a unique identifier to the stream.
        :param simulcast_id: When you create the new simulcast, FastPix assign a universal unique identifier which can contain a maximum of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteSimulcastOfStreamRequest(
            stream_id=stream_id,
            simulcast_id=simulcast_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/live/streams/{streamId}/simulcast/{simulcastId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete-simulcast-of-stream",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SimulcastdeleteResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorSimulcastData, http_res
            )
            raise errors.NotFoundErrorSimulcast(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def get_specific_simulcast_of_stream(
        self,
        *,
        stream_id: str,
        simulcast_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SimulcastResponseData:
        r"""Get a specific simulcast

        Retrieves the details of a specific simulcast associated with a parent live stream. By providing both the `streamId` of the parent stream and the `simulcastId`, FastPix returns detailed information about the simulcast, such as the stream URL, the status of the simulcast, and metadata.

        #### Example
        This endpoint can be used to verify the status of the simulcast on external platforms before the live stream begins. For instance, before starting a live gaming event, the organizer wants to ensure that the simulcast to Twitch is set up correctly. They retrieve the simulcast information to confirm that everything is properly configured.

        :param stream_id: Upon creating a new live stream, FastPix assigns a unique identifier to the stream.
        :param simulcast_id: When you create the new simulcast, FastPix assign a universal unique identifier which can contain a maximum of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSpecificSimulcastOfStreamRequest(
            stream_id=stream_id,
            simulcast_id=simulcast_id,
        )

        req = self._build_request(
            method="GET",
            path="/live/streams/{streamId}/simulcast/{simulcastId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get-specific-simulcast-of-stream",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SimulcastResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorSimulcastData, http_res
            )
            raise errors.NotFoundErrorSimulcast(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def get_specific_simulcast_of_stream_async(
        self,
        *,
        stream_id: str,
        simulcast_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SimulcastResponseData:
        r"""Get a specific simulcast

        Retrieves the details of a specific simulcast associated with a parent live stream. By providing both the `streamId` of the parent stream and the `simulcastId`, FastPix returns detailed information about the simulcast, such as the stream URL, the status of the simulcast, and metadata.

        #### Example
        This endpoint can be used to verify the status of the simulcast on external platforms before the live stream begins. For instance, before starting a live gaming event, the organizer wants to ensure that the simulcast to Twitch is set up correctly. They retrieve the simulcast information to confirm that everything is properly configured.

        :param stream_id: Upon creating a new live stream, FastPix assigns a unique identifier to the stream.
        :param simulcast_id: When you create the new simulcast, FastPix assign a universal unique identifier which can contain a maximum of 255 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetSpecificSimulcastOfStreamRequest(
            stream_id=stream_id,
            simulcast_id=simulcast_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/live/streams/{streamId}/simulcast/{simulcastId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get-specific-simulcast-of-stream",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SimulcastResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorSimulcastData, http_res
            )
            raise errors.NotFoundErrorSimulcast(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    def update_specific_simulcast_of_stream(
        self,
        *,
        stream_id: str,
        simulcast_id: str,
        is_enabled: Optional[bool] = None,
        metadata: Optional[Dict[str, str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SimulcastUpdateResponseData:
        r"""Update a simulcast

        Allows you to enable or disable a specific simulcast associated with a parent live stream. The status of the simulcast can be updated at any point, whether the live stream is active or idle. However, once the live stream is disabled, the simulcast can no longer be modified.

        Webhook event: <a href=\"https://docs.fastpix.io/docs/live-events#videolive_streamsimulcast_targetupdated\">video.live_stream.simulcast_target.updated</a>

        #### Example
        When a `PATCH` request is made to this endpoint, the API updates the status of the simulcast. This can be useful for pausing or resuming a simulcast on a particular platform without stopping the parent live stream.

        :param stream_id: Upon creating a new live stream, FastPix assigns a unique identifier to the stream.
        :param simulcast_id: When you create the new simulcast, FastPix assign a universal unique identifier which can contain a maximum of 255 characters.
        :param is_enabled: When the value is set to false, the simulcast will be disabled for the given stream.
        :param metadata: You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateSpecificSimulcastOfStreamRequest(
            stream_id=stream_id,
            simulcast_id=simulcast_id,
            simulcast_update_request=models.SimulcastUpdateRequest(
                is_enabled=is_enabled,
                metadata=metadata,
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/live/streams/{streamId}/simulcast/{simulcastId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.simulcast_update_request,
                False,
                False,
                "json",
                models.SimulcastUpdateRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="update-specific-simulcast-of-stream",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SimulcastUpdateResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorSimulcastData, http_res
            )
            raise errors.NotFoundErrorSimulcast(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)

    async def update_specific_simulcast_of_stream_async(
        self,
        *,
        stream_id: str,
        simulcast_id: str,
        is_enabled: Optional[bool] = None,
        metadata: Optional[Dict[str, str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SimulcastUpdateResponseData:
        r"""Update a simulcast

        Allows you to enable or disable a specific simulcast associated with a parent live stream. The status of the simulcast can be updated at any point, whether the live stream is active or idle. However, once the live stream is disabled, the simulcast can no longer be modified.

        Webhook event: <a href=\"https://docs.fastpix.io/docs/live-events#videolive_streamsimulcast_targetupdated\">video.live_stream.simulcast_target.updated</a>

        #### Example
        When a `PATCH` request is made to this endpoint, the API updates the status of the simulcast. This can be useful for pausing or resuming a simulcast on a particular platform without stopping the parent live stream.

        :param stream_id: Upon creating a new live stream, FastPix assigns a unique identifier to the stream.
        :param simulcast_id: When you create the new simulcast, FastPix assign a universal unique identifier which can contain a maximum of 255 characters.
        :param is_enabled: When the value is set to false, the simulcast will be disabled for the given stream.
        :param metadata: You can search for videos with specific key value pairs using metadata, when you tag a video in \"key\":\"value\"s pairs. Dynamic Metadata allows you to define a key that allows any value pair. You can have maximum of 255 characters and upto 10 entries are allowed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateSpecificSimulcastOfStreamRequest(
            stream_id=stream_id,
            simulcast_id=simulcast_id,
            simulcast_update_request=models.SimulcastUpdateRequest(
                is_enabled=is_enabled,
                metadata=metadata,
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/live/streams/{streamId}/simulcast/{simulcastId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.simulcast_update_request,
                False,
                False,
                "json",
                models.SimulcastUpdateRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 10000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["408", "429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="update-specific-simulcast-of-stream",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SimulcastUpdateResponse, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.InvalidPermissionErrorData, http_res
            )
            raise errors.InvalidPermissionError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorSimulcastData, http_res
            )
            raise errors.NotFoundErrorSimulcast(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.ValidationErrorResponseData, http_res
            )
            raise errors.ValidationErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.FastpixDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.FastpixDefaultError("Unexpected response received", http_res)
