# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Any
from pydantic import AnyUrl, BaseModel, ConfigDict, Field, RootModel


class UcpCapability(RootModel[Any]):
  root: Any = Field(..., title="UCP Capability")
  """
    Schema for UCP capabilities and extensions. Extensions are capabilities with an 'extends' field. Uses reverse-domain naming for governance.
    """


class Base(BaseModel):
  model_config = ConfigDict(
    extra="allow",
  )
  name: str | None = Field(
    None, pattern="^[a-z][a-z0-9]*(?:\\.[a-z][a-z0-9_]*)+$"
  )
  """
    Stable capability identifier in reverse-domain notation (e.g., dev.ucp.shopping.checkout). Used in capability negotiation.
    """
  version: Version | None = None
  """
    Capability version in YYYY-MM-DD format.
    """
  spec: AnyUrl | None = None
  """
    URL to human-readable specification document.
    """
  schema_: AnyUrl | None = Field(None, alias="schema")
  """
    URL to JSON Schema for this capability's payload.
    """
  extends: str | None = Field(
    None, pattern="^[a-z][a-z0-9]*(?:\\.[a-z][a-z0-9_]*)+$"
  )
  """
    Parent capability this extends. Present for extensions, absent for root capabilities.
    """
  config: dict[str, Any] | None = None
  """
    Capability-specific configuration (structure defined by each capability).
    """


class Discovery(Base):
  """Full capability declaration for discovery profiles. Includes spec/schema URLs for agent fetching."""

  model_config = ConfigDict(
    extra="allow",
  )


class Response(Base):
  """Capability reference in responses. Only name/version required to confirm active capabilities."""

  model_config = ConfigDict(
    extra="allow",
  )


class UcpMetadata(RootModel[Any]):
  root: Any = Field(..., title="UCP Metadata")
  """
    Protocol metadata for discovery profiles and responses. Uses slim schema pattern with context-specific required fields.
    """


class Version(RootModel[str]):
  root: str = Field(..., pattern="^\\d{4}-\\d{2}-\\d{2}$")
  """
    UCP protocol version in YYYY-MM-DD format.
    """


class Services(RootModel[dict[str, "UcpService"]]):
  """Service definitions keyed by reverse-domain service name."""

  root: dict[str, UcpService]


class DiscoveryProfile(BaseModel):
  """Full UCP metadata for /.well-known/ucp discovery."""

  model_config = ConfigDict(
    extra="allow",
  )
  version: Version
  services: Services
  capabilities: list[Discovery]
  """
    Supported capabilities and extensions.
    """


class ResponseCheckout(BaseModel):
  """UCP metadata for checkout responses."""

  model_config = ConfigDict(
    extra="allow",
  )
  version: Version
  capabilities: list[Response]
  """
    Active capabilities for this response.
    """


class ResponseOrder(BaseModel):
  """UCP metadata for order responses. No payment handlers needed post-purchase."""

  model_config = ConfigDict(
    extra="allow",
  )
  version: Version
  capabilities: list[Response]
  """
    Active capabilities for this response.
    """


class Rest(BaseModel):
  """REST transport binding."""

  model_config = ConfigDict(
    extra="allow",
  )
  schema_: AnyUrl = Field(..., alias="schema")
  """
    URL to OpenAPI 3.x specification (JSON format)
    """
  endpoint: AnyUrl
  """
    Merchant's REST API endpoint
    """


class Mcp(BaseModel):
  """MCP transport binding."""

  model_config = ConfigDict(
    extra="allow",
  )
  schema_: AnyUrl = Field(..., alias="schema")
  """
    URL to OpenRPC specification (JSON format)
    """
  endpoint: AnyUrl
  """
    Merchant's MCP endpoint
    """


class A2a(BaseModel):
  """A2A transport binding."""

  model_config = ConfigDict(
    extra="allow",
  )
  endpoint: AnyUrl
  """
    Merchant's Agent Card endpoint
    """


class Embedded(BaseModel):
  """Embedded transport binding (JSON-RPC 2.0 over postMessage). Unlike REST/MCP, the endpoint is per-capability (i.e. per-checkout via continue_url), not per-service."""

  model_config = ConfigDict(
    extra="allow",
  )
  schema_: AnyUrl = Field(..., alias="schema")
  """
    URL to OpenRPC specification (JSON format) defining the embedded protocol
    """


class UcpService(BaseModel):
  """Schema for UCP service definitions. A service defines the API surface for a vertical (shopping, common, etc.) with transport bindings."""

  model_config = ConfigDict(
    extra="allow",
  )
  version: Version
  """
    Service version in YYYY-MM-DD format.
    """
  spec: AnyUrl
  """
    URL to service documentation. Origin MUST match namespace authority.
    """
  rest: Rest | None = None
  """
    REST transport binding
    """
  mcp: Mcp | None = None
  """
    MCP transport binding
    """
  a2a: A2a | None = None
  """
    A2A transport binding
    """
  embedded: Embedded | None = None
  """
    Embedded transport binding (JSON-RPC 2.0 over postMessage). Unlike REST/MCP, the endpoint is per-capability (i.e. per-checkout via continue_url), not per-service.
    """
