# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Any, Literal
from pydantic import BaseModel, ConfigDict, Field, RootModel
from .checkout_resp import CheckoutResponse


class Ap2MandateExtension(RootModel[Any]):
  root: Any = Field(..., title="AP2 Mandate Extension")
  """
    Extends Checkout with cryptographic mandate support for non-repudiable authorization per the AP2 protocol. Uses embedded signature model with ap2 namespace.
    """


class MerchantAuthorization(RootModel[str]):
  root: str = Field(
    ...,
    pattern="^[A-Za-z0-9_-]+\\.\\.[A-Za-z0-9_-]+$",
    title="Merchant Authorization",
  )
  """
    JWS Detached Content signature (RFC 7515 Appendix F) over the checkout response body (excluding ap2 field). Format: `<base64url-header>..<base64url-signature>`. The header MUST contain 'alg' (ES256/ES384/ES512) and 'kid' claims. The signature covers both the header and JCS-canonicalized checkout payload.
    """


class CheckoutMandate(RootModel[str]):
  root: str = Field(
    ...,
    pattern="^[A-Za-z0-9_-]+\\.[A-Za-z0-9_-]*\\.[A-Za-z0-9_-]+(~[A-Za-z0-9_-]+)*$",
    title="Checkout Mandate",
  )
  """
    SD-JWT+kb credential in `ap2.checkout_mandate`. Proving user authorization for the checkout. Contains the full checkout including `ap2.merchant_authorization`.
    """


class Ap2CheckoutResponse(BaseModel):
  """The ap2 object included in checkout responses when AP2 is negotiated."""

  model_config = ConfigDict(
    extra="allow",
  )
  merchant_authorization: MerchantAuthorization
  """
    Merchant's signature proving checkout terms are authentic.
    """


class Ap2CompleteRequest(BaseModel):
  """The ap2 object included in complete_checkout requests when AP2 is negotiated."""

  model_config = ConfigDict(
    extra="allow",
  )
  checkout_mandate: CheckoutMandate
  """
    SD-JWT+kb proving user authorized this checkout.
    """


class ErrorCode(
  RootModel[
    Literal[
      "mandate_required",
      "agent_missing_key",
      "mandate_invalid_signature",
      "mandate_expired",
      "mandate_scope_mismatch",
      "merchant_authorization_invalid",
      "merchant_authorization_missing",
    ]
  ]
):
  root: Literal[
    "mandate_required",
    "agent_missing_key",
    "mandate_invalid_signature",
    "mandate_expired",
    "mandate_scope_mismatch",
    "merchant_authorization_invalid",
    "merchant_authorization_missing",
  ] = Field(..., title="AP2 Error Code")
  """
    Error codes specific to AP2 mandate verification.
    """


class CompleteRequestWithAp2(BaseModel):
  """Extension fields for complete_checkout when AP2 is negotiated."""

  model_config = ConfigDict(
    extra="allow",
  )
  ap2: Ap2CompleteRequest | None = None
  """
    AP2 extension data including checkout mandate.
    """


class CheckoutResponseWithAp2(CheckoutResponse):
  """Checkout extended with AP2 embedded signature support."""

  model_config = ConfigDict(
    extra="allow",
  )
  ap2: Ap2CheckoutResponse | None = None
  """
    AP2 extension data including merchant authorization.
    """
