# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Any
from pydantic import BaseModel, ConfigDict, Field, RootModel
from .types.buyer import Buyer as Buyer_1
from .checkout_update_req import CheckoutUpdateRequest


class BuyerConsentExtensionUpdateRequest(RootModel[Any]):
  root: Any = Field(..., title="Buyer Consent Extension Update Request")
  """
    Extends Checkout with buyer consent tracking for privacy compliance via the buyer object.
    """


class Consent(BaseModel):
  """User consent states for data processing."""

  model_config = ConfigDict(
    extra="allow",
  )
  analytics: bool | None = None
  """
    Consent for analytics and performance tracking.
    """
  preferences: bool | None = None
  """
    Consent for storing user preferences.
    """
  marketing: bool | None = None
  """
    Consent for marketing communications.
    """
  sale_of_data: bool | None = None
  """
    Consent for selling data to third parties (CCPA).
    """


class Buyer(Buyer_1):
  """Buyer object extended with consent tracking."""

  model_config = ConfigDict(
    extra="allow",
  )
  consent: Consent | None = None
  """
    Consent tracking fields.
    """


class Checkout(CheckoutUpdateRequest):
  """Checkout extended with consent tracking via buyer object."""

  model_config = ConfigDict(
    extra="allow",
  )
  buyer: Buyer | None = None
  """
    Buyer with consent tracking.
    """
