# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Literal
from pydantic import AnyUrl, AwareDatetime, BaseModel, ConfigDict
from ..._internal import ResponseCheckout
from .types import (
  buyer as buyer_1,
  line_item_resp,
  link,
  message,
  order_confirmation,
  total_resp,
)
from . import payment_resp


class CheckoutResponse(BaseModel):
  """Base checkout schema. Extensions compose onto this using allOf."""

  model_config = ConfigDict(
    extra="allow",
  )
  ucp: ResponseCheckout
  id: str
  """
    Unique identifier of the checkout session.
    """
  line_items: list[line_item_resp.LineItemResponse]
  """
    List of line items being checked out.
    """
  buyer: buyer_1.Buyer | None = None
  """
    Representation of the buyer.
    """
  status: Literal[
    "incomplete",
    "requires_escalation",
    "ready_for_complete",
    "complete_in_progress",
    "completed",
    "canceled",
  ]
  """
    Checkout state indicating the current phase and required action. See Checkout Status lifecycle documentation for state transition details.
    """
  currency: str
  """
    ISO 4217 currency code.
    """
  totals: list[total_resp.TotalResponse]
  """
    Different cart totals.
    """
  messages: list[message.Message] | None = None
  """
    List of messages with error and info about the checkout session state.
    """
  links: list[link.Link]
  """
    Links to be displayed by the platform (Privacy Policy, TOS). Mandatory for legal compliance.
    """
  expires_at: AwareDatetime | None = None
  """
    RFC 3339 expiry timestamp. Default TTL is 6 hours from creation if not sent.
    """
  continue_url: AnyUrl | None = None
  """
    URL for checkout handoff and session recovery. MUST be provided when status is requires_escalation. See specification for format and availability requirements.
    """
  payment: payment_resp.PaymentResponse
  order: order_confirmation.OrderConfirmation | None = None
  """
    Details about an order created for this checkout session.
    """
