# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Any
from pydantic import ConfigDict, Field, RootModel
from .types import (
  fulfillment_available_method_resp,
  fulfillment_group_resp,
  fulfillment_method_resp,
  fulfillment_option_resp,
  fulfillment_resp,
)
from .checkout_resp import CheckoutResponse


class FulfillmentExtensionResponse(RootModel[Any]):
  root: Any = Field(..., title="Fulfillment Extension Response")
  """
    Extends Checkout with fulfillment support using methods, destinations, and groups.
    """


class FulfillmentAvailableMethod(
  RootModel[
    fulfillment_available_method_resp.FulfillmentAvailableMethodResponse
  ]
):
  root: fulfillment_available_method_resp.FulfillmentAvailableMethodResponse


class FulfillmentOption(
  RootModel[fulfillment_option_resp.FulfillmentOptionResponse]
):
  root: fulfillment_option_resp.FulfillmentOptionResponse


class FulfillmentGroup(
  RootModel[fulfillment_group_resp.FulfillmentGroupResponse]
):
  root: fulfillment_group_resp.FulfillmentGroupResponse


class FulfillmentMethod(
  RootModel[fulfillment_method_resp.FulfillmentMethodResponse]
):
  root: fulfillment_method_resp.FulfillmentMethodResponse


class Fulfillment(RootModel[fulfillment_resp.FulfillmentResponse]):
  root: fulfillment_resp.FulfillmentResponse


class Checkout(CheckoutResponse):
  """Checkout extended with hierarchical fulfillment."""

  model_config = ConfigDict(
    extra="allow",
  )
  fulfillment: Fulfillment | None = None
  """
    Fulfillment details.
    """
