# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Literal
from pydantic import AnyUrl, ConfigDict
from .payment_instrument_base import PaymentInstrumentBase


class CardPaymentInstrument(PaymentInstrumentBase):
  """A basic card payment instrument with visible card details. Can be inherited by a handler's instrument schema to define handler-specific display details or more complex credential structures."""

  model_config = ConfigDict(
    extra="allow",
  )
  type: Literal["card"]
  """
    Indicates this is a card payment instrument.
    """
  brand: str
  """
    The card brand/network (e.g., visa, mastercard, amex).
    """
  last_digits: str
  """
    Last 4 digits of the card number.
    """
  expiry_month: int | None = None
  """
    The month of the card's expiration date (1-12).
    """
  expiry_year: int | None = None
  """
    The year of the card's expiration date.
    """
  rich_text_description: str | None = None
  """
    An optional rich text description of the card to display to the user (e.g., 'Visa ending in 1234, expires 12/2025').
    """
  rich_card_art: AnyUrl | None = None
  """
    An optional URI to a rich image representing the card (e.g., card art provided by the issuer).
    """
